<?php
if (!defined('ABSPATH')) { exit; }

// ===== CONFIG =====
// Replace with your product slug (used to store option)
if (!defined('MY_PLUGIN_SLUG')) define('MY_PLUGIN_SLUG', 'my-plugin');
// REPLACE with your Ed25519 Public Key (Base64)
if (!defined('MY_PLUGIN_PUBKEY')) define('MY_PLUGIN_PUBKEY', 'REPLACE_ME_BASE64');

function my_plugin_license_is_valid(): bool {
    if (!function_exists('sodium_crypto_sign_verify_detached')) return false;

    $pub = base64_decode(MY_PLUGIN_PUBKEY);
    if (!$pub) return false;

    $lic = get_option(MY_PLUGIN_SLUG . '_license');
    if (!$lic || strpos($lic, '.') === false) return false;

    list($t64, $s64) = explode('.', $lic, 2);
    $token = base64_decode($t64);
    $sig   = base64_decode($s64);
    if (!$token || !$sig) return false;

    if (!sodium_crypto_sign_verify_detached($sig, $token, $pub)) return false;

    $claims = json_decode($token, true);
    if (!$claims) return false;

    $host = strtolower($_SERVER['HTTP_HOST'] ?? '');
    if (($claims['host'] ?? '') !== $host) return false;

    $exp = (int)($claims['exp'] ?? 0);
    if ($exp && time() > $exp) return false;

    return true;
}
