<?php
namespace App;
class Utils {
    public static function normalizeDigits(string $s): string {
        $map = ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9','٠'=>'0','١'=>'1','٢'=>'2','٣'=>'3','٤'=>'4','٥'=>'5','٦'=>'6','٧'=>'7','٨'=>'8','٩'=>'9'];
        return strtr($s, $map);
    }
    public static function parseDateOrJalali(string $s): int {
        $s = trim(self::normalizeDigits($s));
        $s = str_replace(['.', '\\'], ['-', '-'], $s);
        $s = str_replace('/', '-', $s);
        $parts = explode('-', $s);
        if (count($parts) === 3) {
            [$y,$m,$d] = array_map('intval', $parts);
            if ($y >= 1300 && $y < 1600) { // jalali
                [$gy,$gm,$gd] = self::jalali_to_gregorian($y,$m,$d);
                return (int)strtotime(sprintf('%04d-%02d-%02d 23:59:59', $gy,$gm,$gd));
            } else {
                return (int)strtotime(sprintf('%04d-%02d-%02d 23:59:59', $y,$m,$d));
            }
        }
        return 0;
    }
    // Minimal Jalali -> Gregorian converter
    public static function jalali_to_gregorian($j_y, $j_m, $j_d) {
        $jy = $j_y - 979; $jm = $j_m - 1; $jd = $j_d - 1;
        $j_day_no = 365*$jy + intdiv($jy,33)*8 + intdiv((($jy%33)+3),4);
        $j_months = [31,31,31,31,31,31,30,30,30,30,30,29];
        for ($i=0;$i<$jm;++$i) $j_day_no += $j_months[$i];
        $j_day_no += $jd;
        $g_day_no = $j_day_no + 79;
        $gy = 1600 + 400*intdiv($g_day_no,146097); $g_day_no%=146097;
        $leap = true;
        if ($g_day_no >= 36525) {
            $g_day_no--; $gy += 100*intdiv($g_day_no,36524); $g_day_no %= 36524;
            if ($g_day_no >= 365) $g_day_no++; else $leap = false;
        }
        $gy += 4*intdiv($g_day_no,1461); $g_day_no %= 1461;
        if ($g_day_no >= 366) { $leap=false; $g_day_no--; $gy += intdiv($g_day_no,365); $g_day_no %= 365; }
        $gd = $g_day_no + 1; $g_month = [0,31,(28+$leap),31,30,31,30,31,31,30,31,30,31];
        for ($gm=1;$gm<=12;$gm++){ $v=$g_month[$gm]; if ($gd<=$v) break; $gd-=$v; }
        return [$gy,$gm,$gd];
    }
    public static function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES|ENT_SUBSTITUTE,'UTF-8'); }
    public static function rrmdir($dir) {
        if (!is_dir($dir)) return;
        $files = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($dir, \FilesystemIterator::SKIP_DOTS), \RecursiveIteratorIterator::CHILD_FIRST);
        foreach ($files as $file) { $file->isDir() ? rmdir($file->getRealPath()) : unlink($file->getRealPath()); }
        @rmdir($dir);
    }
}
