<?php $tab=$_GET['tab']??'local'; $lang=$_GET['lang']??'fa'; ?>
<?php

use App\Utils;
use App\Encoder;
require __DIR__.'/../app/Utils.php';

$hasSodium = extension_loaded('sodium');
$sourceDir = realpath(__DIR__.'/../source') ?: (__DIR__.'/../source');
$outDir    = realpath(__DIR__.'/../output') ?: (__DIR__.'/../output');
@mkdir($sourceDir, 0775, true);
@mkdir($outDir, 0775, true);
$actionMsg = '';
$summary = null;
$log = [];

if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!$hasSodium) { $actionMsg = '❌ اکستنشن sodium فعال نیست.'; }
    else {
        require __DIR__.'/../app/Encoder.php';
        $domains = array_values(array_filter(array_map('trim', preg_split('/\r?\n/', (string)($_POST['domains'] ?? '')))));
        $errmsg = (string)($_POST['errmsg'] ?? 'دسترسی غیرمجاز یا مهلت استفاده پایان یافته است.');
        $expiresStr = (string)($_POST['expires'] ?? '');
        $expiresTs = $expiresStr? Utils::parseDateOrJalali($expiresStr) : 0;
        $opt = [
            'domains'=>$domains,
            'errmsg'=>$errmsg,
            'expires'=>$expiresTs,
            'online'=> isset($_POST['online_only'])?1:0,
            'obf'   => isset($_POST['obfuscate'])?1:0,
            'wp'    => isset($_POST['is_wp'])?1:0,
            'copy_non_php' => isset($_POST['copy_non_php'])?1:0,
        ];
        $enc = new Encoder($sourceDir, $outDir);
        $summary = $enc->encodeAll($opt);
        $log = $enc->log;
        $buildId = $enc->getBuildId();
        file_put_contents($outDir.'/build.json', json_encode(['build'=>$buildId,'options'=>$opt,'time'=>time()], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
        $actionMsg = '✅ عملیات انجام شد. Build ID: '.$buildId;
        // create zip
        $zipFile = __DIR__.'/../output_'.$buildId.'.zip';
        $zip = new ZipArchive();
        if ($zip->open($zipFile, ZipArchive::CREATE|ZipArchive::OVERWRITE)) {
            $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($outDir, FilesystemIterator::SKIP_DOTS));
            foreach ($it as $f) {
                $zip->addFile($f->getRealPath(), substr($f->getRealPath(), strlen($outDir)+1));
            }
            $zip->close();
            $download = basename($zipFile);
        }
    }
}
?><!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>PHP Encoder Pro</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css">
<link rel="stylesheet" href="../assets/rtl.css">

<link rel="stylesheet" href="../assets/ui.css">
</head>
<body class="bg-gradient-to-br from-yellow-50 to-orange-50 min-h-screen">
  <div id="pwrap" class="progress-wrap"><div id="pbar" class="progress"></div></div>
<div id="toast" class="toast" data-msg="<?php echo isset($actionMsg)?htmlspecialchars($actionMsg):''; ?>"><b>PHP Encoder</b><div class="msg"></div></div>
<div class="container">
    <div class="flex items-center justify-between mb-6">
      <div class="logo"><img src="../assets/logo.svg" alt="logo"/><span class="dot"></span></div>
      <h1 class="text-2xl font-extrabold text-gray-800">PHP Encoder <span class="badge">Pro</span></h1>
<div class="flex gap-3 mb-4"><a class="tab <?php echo $tab==='local'?'active':''; ?>" href="?tab=local&lang=<?php echo $lang; ?>">رمزنگاری محلی</a> <a class="tab <?php echo $tab==='license'?'active':''; ?>" href="?tab=license&lang=<?php echo $lang; ?>">با لایسنس‌سرور</a> <div class="ml-auto text-xs"><a href="?tab=<?php echo $tab; ?>&lang=fa">FA</a> | <a href="?tab=<?php echo $tab; ?>&lang=en">EN</a></div></div>
      <div class="text-sm text-gray-600 ltr">PHP 8+ · sodium · AEAD(XChaCha20-Poly1305) · Ed25519</div>
    </div>

    <?php if(!$hasSodium): ?>
      <div class="p-4 rounded-xl bg-red-50 border border-red-200 text-red-700 mb-6">اکستنشن <b>sodium</b> روی این هاست فعال نیست.</div>
    <?php endif; ?>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
      <div class="bg-white rounded-2xl shadow-xl p-6">
        <form method="post">
          <label class="block text-sm font-bold mb-1">دامنه‌های مجاز</label>
          <textarea name="domains" rows="6" class="w-full border rounded-xl p-3 focus:ring-2 focus:ring-green-400" placeholder="example.com&#10;sub.example.com"><?php echo Utils::h($_POST['domains'] ?? ''); ?></textarea>

          <label class="block mt-4 text-sm font-bold mb-1">پیام خطا</label>
          <textarea name="errmsg" rows="3" class="w-full border rounded-xl p-3 focus:ring-2 focus:ring-green-400" placeholder="دسترسی غیرمجاز یا مهلت استفاده پایان یافته است."><?php echo Utils::h($_POST['errmsg'] ?? ''); ?></textarea>

          <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
            <div>
              <label class="block text-sm font-bold mb-1">تاریخ انقضا (شمسی/میلادی)</label>
              <input type="text" name="expires" value="<?php echo Utils::h($_POST['expires'] ?? ''); ?>" class="w-full border rounded-xl p-3 focus:ring-2 focus:ring-green-400" placeholder="1404-07-01 یا 2026-01-20">
            </div>
          </div>

          <div class="mt-4 space-y-2 text-sm">
            <label class="flex items-center gap-2"><input type="checkbox" name="online_only" <?php echo isset($_POST['online_only'])?'checked':'';?> > فقط آنلاین اجرا شود</label>
            <label class="flex items-center gap-2"><input type="checkbox" name="obfuscate" <?php echo isset($_POST['obfuscate'])?'checked':'';?> > Obfuscate ثانویه کدها</label>
            <label class="flex items-center gap-2"><input type="checkbox" name="is_wp" <?php echo isset($_POST['is_wp'])?'checked':'';?> > نگهبان وردپرسی</label>
          </div>

          <p class="text-xs text-gray-500 mt-3">ورودی: <code>source/</code> | خروجی: <code>output/</code>. سپس فایل ZIP خروجی ساخته می‌شود.</p>
          <button class="mt-4 px-5 py-3 bg-green-500 hover:bg-green-600 text-white rounded-xl shadow-lg" type="submit">انجام عملیات</button>
        
<?php if($tab==='license'): ?>
  <div class="mt-6 p-4 border rounded-xl bg-gray-50">
    <h3 class="font-bold mb-2">License Server</h3>
    <label class="block text-sm font-bold mb-1">License Server URL</label>
    <input type="text" name="lic_url" value="<?php echo htmlspecialchars($_POST['lic_url'] ?? 'https://license.example.com'); ?>" class="w-full border rounded-xl p-2">
    <label class="block text-sm font-bold mb-1 mt-3">App ID</label>
    <input type="text" name="lic_app" value="<?php echo htmlspecialchars($_POST['lic_app'] ?? 'myapp'); ?>" class="w-full border rounded-xl p-2">
    <label class="block text-sm font-bold mb-1 mt-3">Public Key (Base64, Ed25519)</label>
    <textarea name="lic_pub" rows="2" class="w-full border rounded-xl p-2"><?php echo htmlspecialchars($_POST['lic_pub'] ?? ''); ?></textarea>
    <label class="block text-sm font-bold mb-1 mt-3">Cache (seconds)</label>
    <input type="text" name="lic_cache" value="<?php echo htmlspecialchars($_POST['lic_cache'] ?? '3600'); ?>" class="w-full border rounded-xl p-2">
  </div>
<?php endif; ?>
</form>

      </div>

      <div class="bg-white rounded-2xl shadow-xl p-6">
        <h2 class="font-bold">گزارش</h2>
        <?php if($actionMsg): ?>
          <div class="mt-2 p-3 rounded-lg <?php echo strpos($actionMsg,'✅')!==false?'bg-green-50 text-green-700 border border-green-200':'bg-yellow-50 text-yellow-700 border border-yellow-200';?>"><?php echo Utils::h($actionMsg); ?></div>
        <?php endif; ?>

        <?php if($summary): ?>
          <div class="mt-3 text-sm">
            <div>تعداد فایل: <b><?php echo $summary['files']; ?></b> | موفق: <b class="text-green-700"><?php echo $summary['ok']; ?></b> | خطا: <b class="text-red-700"><?php echo $summary['fail']; ?></b></div>
          </div>
        <?php endif; ?>

        <?php if(!empty($log)): ?>
          <pre class="mt-3 bg-gray-50 border p-3 rounded-xl h-80 overflow-auto"><?php foreach($log as $l) echo Utils::h($l)."\n"; ?></pre>
        <?php else: ?>
          <p class="text-sm text-gray-500 mt-2">پس از اجرای عملیات، لاگ کامل در اینجا نمایش داده می‌شود.</p>
        <?php endif; ?>

        <?php if(isset($download)): ?>
          <a class="mt-4 inline-block px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-lg" href="<?php echo Utils::h($download); ?>">دانلود خروجی ZIP</a>
        <?php endif; ?>
      </div>
    </div>

    <div class="mt-10 bg-white rounded-2xl shadow p-6">
      <h3 class="font-bold mb-2">درباره</h3>
      <p class="text-sm text-gray-700">رمزنگاری با AEAD(XChaCha20-Poly1305)، کلید per-file مشتق‌شده، امضای Ed25519، Obfuscation کلید و چک‌های دامنه/انقضا/آنلاین. بدون Loader خارجی؛ فقط ext/sodium.</p>
    </div>
  </div>
<script src="../assets/ui.js"></script></body>
</html>
