
(function(){
  const root = document.documentElement;
  const saved = localStorage.getItem('theme');
  if(saved==='dark') document.body.classList.add('dark');
  document.getElementById('toggleTheme')?.addEventListener('click', e=>{
    document.body.classList.toggle('dark');
    localStorage.setItem('theme', document.body.classList.contains('dark')?'dark':'light');
  });

  const form = document.querySelector('form');
  const pwrap = document.getElementById('pwrap');
  const pbar = document.getElementById('pbar');
  const toast = document.getElementById('toast');
  if(form){
    form.addEventListener('submit', ()=>{
      if(pwrap){ pwrap.classList.add('show'); pbar.style.width='10%'; }
      let w=10;
      const id = setInterval(()=>{ w=Math.min(95,w+Math.random()*12); pbar.style.width=w+'%'; }, 300);
      form.addEventListener('ajaxdone', ()=>{ clearInterval(id); pbar.style.width='100%'; setTimeout(()=>pwrap.classList.remove('show'), 800); });
    });
  }
  // if server rendered a message, just show toast
  if(toast && toast.dataset.msg){ toast.querySelector('.msg').textContent = toast.dataset.msg; toast.classList.add('show'); setTimeout(()=>toast.classList.remove('show'), 4000); }
})();


// Neo enhancements
(function(){
  const navLinks = document.querySelectorAll('.sidenav a[data-target]');
  navLinks.forEach(a=>a.addEventListener('click', e=>{
    e.preventDefault();
    const id = a.getAttribute('data-target');
    const el = document.querySelector(id);
    if(el){ el.scrollIntoView({behavior:'smooth', block:'start'}); }
    navLinks.forEach(n=>n.classList.remove('active')); a.classList.add('active');
  }));

  const form = document.getElementById('encForm');
  document.addEventListener('keydown', (e)=>{
    if((e.ctrlKey || e.metaKey) && e.key.toLowerCase()==='enter'){
      e.preventDefault(); form?.requestSubmit();
    }
  });

  const ta = document.querySelector('textarea[name="domains"]');
  const counter = document.getElementById('domainsCount');
  if(ta && counter){
    const f=()=>{ const lines = ta.value.split(/\\r?\\n/).filter(s=>s.trim().length>0).length; counter.textContent=lines; };
    ta.addEventListener('input', f); f();
  }
})();
