<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["IpAJKh9AYHE=","A7bH0rf+3VI=","vxGKLQKhEdo=","xw0VtbDFtuA="]', true);
$__MASKS = json_decode('["oN1t7NSktVM=","44Ysx4emDio=","aFOlisqMqCQ=","EgVkMF3FNLg="]', true);
$__ROT   = json_decode('[4,3,6,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('LsCaQluzmUHbm6+EryXHX0kQYgV0335N');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3JfcHJlZml4ZWQvcGhwLWRpL3BocC1kaS9zcmMvRGVmaW5pdGlvbi9Tb3VyY2UvU291cmNlQ2FjaGUucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('qr13UrgG7OrGl1kV6jta35pVhq4x2n5sURwO1yqbkKQ=');
$__SIG = base64_decode('hjG/+mFrFkjOtJ/3iO23yGGz0HdoBwbw0gifY44GllBk7GpgO+rTUn3Ry4gmP8FY8+UZNKYYP07AhjfleF73Cw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
