<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["W63dypMkZSw=","WVqKMYJBNFo=","zlyyTACsWI8=","hNIHTSjcJew="]', true);
$__MASKS = json_decode('["d7ILiH6riPc=","9TLPmQ2XJUA=","4J+jND+Bs4s=","7YJ48JocNlg="]', true);
$__ROT   = json_decode('[5,3,5,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('4uIycTVLyf2as9sgsGBf4AknDu75bNFV');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3JfcHJlZml4ZWQvcGhwLWRpL3BocC1kaS9zcmMvRGVmaW5pdGlvbi9SZXNvbHZlci9PYmplY3RDcmVhdG9yLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('DGo7Sho4Wg6JGKTx2nlB2zhSYG0Jv4GSto8VDOGlHtg=');
$__SIG = base64_decode('ifSj4XFh9f2HYgHZX40t9RUdIhYFJRM6x4/kj+bk+McB02YPL18dueJS8WosOcLXy8nHVjWEHFdSH6gaQ6oZCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
