<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["YUKrQ54k6PI=","XCWqw13iDdA=","g+n\/YHxza98=","XwA6q\/K8ZOY="]', true);
$__MASKS = json_decode('["XA8OJ2TXLRA=","3NP9cGl8F74=","oTeNzjPXQJE=","5uSlnaC+kmQ="]', true);
$__ROT   = json_decode('[7,4,2,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('3sqPrTeGuZIvGPhwwRU5k4qx+GSrDdf4');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3JfcHJlZml4ZWQvcGhwLWRpL3BocC1kaS9zcmMvRGVmaW5pdGlvbi9PYmplY3REZWZpbml0aW9uLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('aOjcl+Vw0YsXYpJ5X9gdwIinINirnE+o/92dyot/NvM=');
$__SIG = base64_decode('SZuYG/MovNpNipDVBbb2dzBBlFrTNtf8h1CpY85Yb7j6ETFUcCdDhEwPIvnjlC8T/lnr87BoDwzGI+xAJi1dDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
