<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["UPw2tlY\/4Nc=","p4HSlBSlgzk=","LiVI9Q3jAjo=","DRg8VxqwOw4="]', true);
$__MASKS = json_decode('["w6+5GguaL6E=","214R6Y+dNv4=","\/5eps3gVjbQ=","3yOWKwkD3LQ="]', true);
$__ROT   = json_decode('[1,3,5,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('I2RdLfW9UyizWWP1ZK8S/dZCz0fahyBG');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3JfcHJlZml4ZWQvcGhwLWRpL3BocC1kaS9zcmMvRGVmaW5pdGlvbi9IZWxwZXIvRmFjdG9yeURlZmluaXRpb25IZWxwZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('TIARLj5UNkTR6ACm9dZbcynrkU8TTsy3foYft8uXxyc=');
$__SIG = base64_decode('zPJxxPu3iuAN6kWxgXBldrcEFglb2zNFcFvqn4gadirsxQUwppxCWHN7JAenUdwYgTuQD3c7FobK3lGI3czHBA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
