<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["KlF\/ng8nRnI=","ajWwFGzgHPc=","NCnFKT8xduc=","gLZLvqic5tg="]', true);
$__MASKS = json_decode('["WJAuBB1eoQE=","7JCwhjS\/Pws=","hVQIGn1HiDg=","SC6q4EXKl\/A="]', true);
$__ROT   = json_decode('[4,7,5,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('LQesjfZIyfQK1ggqCeSxragpMEPqsi8F');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3JfcHJlZml4ZWQvcGhwLWRpL3BocC1kaS9zcmMvQ29udGFpbmVyQnVpbGRlci5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('Vk691yfcM/Ju7AZG/bs7SBGIC0KzJrJO1MtKjvvgJ60=');
$__SIG = base64_decode('kp11u+I+19/L3EGfM/ab17ZXSobRgtD0u7/rEKebS1pOnMYZQcaCWRnVNEk8IOPbbduD7gItJRkMuHHxpzfECQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
