<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["modnoSwQKzg=","5PxRBeQPcV8=","nn7MCTTVh6o=","dCfBFQBBfIo="]', true);
$__MASKS = json_decode('["VsyTVNEHSIM=","b7sGsrMJvEs=","egHLrMJwcmQ=","+52uMDhmvig="]', true);
$__ROT   = json_decode('[4,2,2,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('ZYvq9/+iJkRa72xT0APDftisyy15sI2D');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3JfcHJlZml4ZWQvcGhwLWRpL3BocC1kaS9zcmMvQ29tcGlsZXIvT2JqZWN0Q3JlYXRpb25Db21waWxlci5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('XinjmL5AI6ojJguPKsfPKkUxKuksVEtCb9NxzRrRVZM=');
$__SIG = base64_decode('H6MbvJtBCEnaPaC24YILVC5/8k3hQ3NkcBK3exushaQMfzAJzP/eE5jfB4fdYv1PaHV60OhHS0LR4iUk4wMEBQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
