<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["yY43OI0KiDk=","sQjpARQ\/d64=","M2f50zuzfUs=","QO+XHQQYx08="]', true);
$__MASKS = json_decode('["k5\/zrzFFTS4=","Eo5q0oAOjtQ=","SzEuxuSGUDM=","es0VbvN9zCo="]', true);
$__ROT   = json_decode('[6,4,6,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('9MYN9cZlMGiyMHU1u0AnizCEdvti1+fQ');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3JfcHJlZml4ZWQvbGFyYXZlbC9zZXJpYWxpemFibGUtY2xvc3VyZS9zcmMvU2VyaWFsaXplcnMvTmF0aXZlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('kEAm77/uXQBMynwkDhYT5ppL5v06p4zeX89egv4cEAg=');
$__SIG = base64_decode('gfMOtvqAzzAMeHjWTSvZQEPO53s1+zyMCM2z9xMP+Ku6oT4AlANclQb/ptzQz4cNgMtyohxjWmD7H6fL2U46AA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
