<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["k4BBvQ4UoWc=","ImkefQaV244=","ounhj97vPho=","7syY+q9Zq3w="]', true);
$__MASKS = json_decode('["MMB01gxHaAo=","2sw\/AmyvpLo=","WbS8sh8kVvY=","Y08T2H04U4Q="]', true);
$__ROT   = json_decode('[4,5,3,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('PiiNQDKFpqgxF+FG2M4XebY/poJxkH04');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3IvY29tcG9zZXIvYXV0b2xvYWRfc3RhdGljLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('KJPos9ws8mHQjz4ZIBL20VL0b+A3aIyzjhEzbEW8Gb0=');
$__SIG = base64_decode('zpZsLZLMer7Up5ymNv8Xb1HvWBXkGQwIpKIhoPwnyrRyCIn7cBWgFbBn8f8O53Kuyyx6xm/8A1U4H5i9wwgKCw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
