<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["5FHPsWTtSn0=","NsUXyeinxhc=","fRTida77qlU=","Rvj3ZyFxjBE="]', true);
$__MASKS = json_decode('["o0SCPnERL1I=","km8KDpCdU8o=","Y4n9qdM+umc=","HhBysK9Lnh8="]', true);
$__ROT   = json_decode('[6,1,5,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('9m5TEtsy3eOIj6mxQgnIRBgcorL1sjVF');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3IvY29tcG9zZXIvYXV0b2xvYWRfY2xhc3NtYXAucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('tuEB8YktRu+H1N+aIbo5BtaRAKb5ZvZ+VcwvtDDd7pM=');
$__SIG = base64_decode('vyDycXTLOjizvzdLlsi1Q6iKVDVV6+Y5+LIdl7P6ul9/BlTDRbeoYYIrH4/BQvdlizGw2aqLxGE9JOeeu3JtBw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
