<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["XORjO+7FiAg=","upnUGqApaF8=","wt\/Z4FmhcvM=","Yx7QKrCSuF8="]', true);
$__MASKS = json_decode('["5tQJ+IM3SzQ=","N3STOMfeZNA=","ryMRl8rBmBs=","TaQ\/49rTUHw="]', true);
$__ROT   = json_decode('[7,4,6,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('i+4gelLijAChT4e9EoyHMJRvdZXxsAR4');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3IvY29tcG9zZXIvSW5zdGFsbGVkVmVyc2lvbnMucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('LJSBL19zj0Uc+XRjmVHHrH69bge6wtZnyc690Wouw48=');
$__SIG = base64_decode('kWYNlmBOxlNS6X4YBW58BSmXi2J0L3RkH5ur+HmBxeiJVJe3NwM4p7lSAq/h8NqPyhr3XA4Gl0ldvwUhcwyWDQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
