<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["JYyzWWEP1aA=","LC8ILQogLJk=","FEgxVohjBAQ=","eUpKgtGFuTI="]', true);
$__MASKS = json_decode('["eIbIGdZ\/P1Y=","sqvU3ENPCyo=","GpzK8S2LF3U=","J0SDNKGNLP0="]', true);
$__ROT   = json_decode('[5,1,6,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('FBniTw1f+x5Qg+d8xqasJSuMjeMObJLg');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci92ZW5kb3IvY29tcG9zZXIvQ2xhc3NMb2FkZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('5sVqLHiO/Q3dpiX0GLR4PqBtELqeub241ZGXSBGli5o=');
$__SIG = base64_decode('ueCpB09+eUEcepSC28WR74qNTz5cwVKlikEJD3HFh6o0xj8/DVaAG5QP+lan2BuzA45AcqemMurSve3ZXZlBAg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
