<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["zVYruNOLZvg=","D7R9KfO2qwQ=","8JKTc4bLKNw=","VkQ6INxy5+c="]', true);
$__MASKS = json_decode('["E1olXgT7LZM=","q3XjY9w\/rxU=","EogRKYlOee8=","z4KRM3AjmHM="]', true);
$__ROT   = json_decode('[2,1,2,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('9e5yCC3SefpqYI/d6+HRHWcoGclJDwVq');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL3dwLWNsaS9saWJyYXJ5LnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('SvIu7DayFWoOXpUDck4u/acy5KyRk/qzbW+4aCLygro=');
$__SIG = base64_decode('yb38RO3Hyk1IrN7umgx2fUJ9wAuh831AodbLmqJ7y/J4K/Diljq+QNsmM77H0gz9hLl7uGYvT9/oJgHsmLFOBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
