<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["EIZLanV5U44=","b0kfiSEn7gY=","hUCvOvJ9AYg=","RguJeNaYO2Q="]', true);
$__MASKS = json_decode('["98x1OYVlBiI=","FS6hz51Wvjg=","6ZnTKP9OIWs=","asCaQ1G2fYM="]', true);
$__ROT   = json_decode('[5,6,7,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('tFf5Yp0MDyIGCZKfqSiU7g7NYET3UJbD');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL3VzYWdlL21vZHVsZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('vaBicFEuQi+Lp+7N6rYl+l9x2AS16NXwW13cRj/9tis=');
$__SIG = base64_decode('Hrrr9WIGeavEFfyIGlpVDGRRtqyJhqEYXeHR0oy4cW1aXcrNhd03LG/t1yYDO1mf6kp/VotUGNA9b4kru8PqDA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
