<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["N+7BZPqlFfA=","G6bbn0kYDJc=","4DL9Tpsic5c=","vQ6q7T5O3eE="]', true);
$__MASKS = json_decode('["ezcGugV4V0A=","dZ1dmUx\/Aqs=","CBlpAru3cQ4=","o43EvDWm62o="]', true);
$__ROT   = json_decode('[4,3,5,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('o0SF1qLsQIkwpWkZJh/yh0AcqAIqC7cg');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL3N5c3RlbS1pbmZvL3JlcG9ydGVycy93b3JkcHJlc3MucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('dNGBwHbKKsgSUK5CEC4/TDCc5yvPcOJ4UkGWVa+8neI=');
$__SIG = base64_decode('QmcoYECasl2mE3tj91p0HSxewFCjEmY5g63RsFdI1BJuoDrfdu7n3CndR3Y3H8s9eWMEglGCqsV5HVM+UnGADg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
