<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["DJ88P3tFXkI=","JYmRqO8sukA=","fjujlzF22H0=","R8O1S7VqiA4="]', true);
$__MASKS = json_decode('["3+g+q72aqs4=","o3TywDP4FlY=","a9TBLHgZEZg=","EG5+1eN5Kpo="]', true);
$__ROT   = json_decode('[5,2,3,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('XUTeAtwYar7QrYBcRlkbIVGww7T4KGtL');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL3N5c3RlbS1pbmZvL3JlcG9ydGVycy9zZXJ2ZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('dWKMuwG76eoRRRTRu0p18G8Es2k/T8LFao0U1d0sC7o=');
$__SIG = base64_decode('oLX0u2Q7uW6occboS6O0W+UMNZ48kpy4oXNm+UBnOsPfiA6+y+MkzaEN66crKwA4OZgQ+BFbPSTDcNu5kryZBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
