<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["CDUX9pYhfbM=","5Lmk50seoGw=","9Supsxi4lRU=","qM3gRB\/xwgc="]', true);
$__MASKS = json_decode('["p+zFgmJ3Wkk=","LbkjL0zMab0=","V9jJ3oyGpDM=","3N7AILDeAJ0="]', true);
$__ROT   = json_decode('[1,5,6,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('Evx5bIP/YA3NFoj52gZhaS6btR6yVBGr');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL3NhZmUtbW9kZS9tb2R1bGUucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('P1LjUNY81gyOommbz/KRpcKlmobodQhWYO5V/G0ui7o=');
$__SIG = base64_decode('Hs1pkRVIMzA9rwXM0dsOviaW3NPGzFndsdHMiOPapC/qxZ6QdBuLA9XaxeII74EtjUISsgBFaZJbYhFZYXPiDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
