<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["6xCId6KGAmU=","qldKF6VxqwU=","xRhkn8Xrr1Y=","EmMizcYHZrI="]', true);
$__MASKS = json_decode('["53gBFrbpms0=","x6eomCtdG+Y=","ygFTjXAyZWQ=","WUyoLJutdSE="]', true);
$__ROT   = json_decode('[2,3,1,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('2G+y/Qm24GD4caCjlXHWu2glGC2OJlUq');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL3BhZ2UtdGVtcGxhdGVzL21vZHVsZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('O7+WqsXx2JrD92JCtV3ZimueO374UtukBQEMSvFoeP5rEf6qpAbjrJtCoxJ9gHsPjQ2eUbKnS6w/xkNJ9VUaC9uRtQxO/UR9H3AAY21mEtN8nvtKyGXrP6fl0Sns1wcHVvjfPjoTf6aobdPviTetfH2TjZbIzJdTJkSiOIea9VOogwMZBvPU9yqM0MSlVj6D3gkoweB2dl/nLU2HiUk2F+vpWmZKfZaXdHjYbk3XsruwiLBcOFNe7K+R+7I8ghDVsjQizEiuzGTvPAYhUdJHsB/h0rpXZK603I9MWP2aqiEgNlKhjk+nT3AjbVJsrYlDjA1mez+K5k1kdcPVZYsb3Q11MTI0kVvOlXdtWS7qveCYj01xaAlp7Qbj6mkTqYV772Ri2L1BBpDUYQvQZIlLhBagzl1jJLLXAgA3iYsxMPVxIxUd323IU/hGANdST2KkaFRvoMbDKV8n51Oz06Xh7ss3MEVaRsfJ+pikpSYSkKue+XsCGQ6URGFquwev+OyWEcxmSShbeepRVKvt55R1aarOAsTHlqlgR1vVB3pjMtcF8twDk+EHGSxbwcLP0+oAz3SB59O/MrUdaBUTsK92RZ4JOvS0KOYg3lgSoU4MVqLJLJT3vt6KpFE98IrzKxaxpLycZ/Mg5OktoL85opFXZnioEQMHciFLRGAgPZZMRbdJgV7ZjTjRUJVSJCP0QfT+QkSuWdyQ79O7NcVDh/S6ZqUfhsj//NNACH7Xr5uZoRhBK5/z8YPbEVd2rE0dmJ7ZZC0u9925nd4S6ln8scC62uYXxAMOLozRjAVnBhPKESfjPJSRnoYPIeMwr3dvNpZg0GKqaAQa4TRupt3NqS71r0m+z3g9iTKORttaVMmbF9QDFhZ9SnZsE0AlaKAz9NKgYshy7qGXcuNmBkW8W65gR418JYNZzAhkwN/bK57NsFA4aH/DULTD7RLvLrh9QIBWP/hlTW43kyGP2kBEPot5NpSgpo+q86/BRMTBKyrgZPPvnmZsRkPghAcaFbIPdZ8/x9X3O4J1YEAiVkB6aOFSSNZoaI2ZzyxiQ3ZDo1OqnO3RVcIyrs+Kmbn8YyXAKWLh97n5AyLiS8f+bTHEZyYerRUsjpcs1kxxtOTfSZX8KqLDQKmWMyShjgMNfo4heuiSk6qz8Sa1wTWOxSBaC32tHnHo8Fg4svwwHBlLOvldW5l3kG0jiM20y4DIU36oO52ZqKGzHrxIGUKR56lXFSrdow/5sKLkIvzRo0rj/6Z/vsYGeEn+5R5gxzYWrlTOts/ks5QAiPZ6sFMcRd2+VGf0KtpS6k9+73ldXV01wjJlnMAta8KkcZ7cZzVF7edZoJvsL66eULC6WvnlPsohk7AMZHappHoV4UF4M8KGNmKfuKcLKk8CB7BUtt9q1xeyw0vvNash5P7ayneleoHsTj6afaEBu9BQ63lGwWSYKFTK7/JbXmikJZ4vOZxnjGhkuuNxSWF8z1kYowDQbTjiwBbuG7HJmeShaG2MgNf98GalbVqCpApeWQX8VkbKXzqoNmNgrpWl0LvZcYqZVFMv9s8SGwV9/uZLo6kIUvnBHjRyPOf3ANylM9B4Q+KSb0IP5RO/ebUg4PgwkirQJIyeeY5vAcFuTntjE3E+GCGH1qCKggqW0BKVGHrOlfXMglo1aWFL5ksIs1ESlz03fg+V2gdS9VYItir8HfFgc+QQKO0c4c45YZDNellBsIB3f2Zr3mJQ42joyJ0M2C+ilyApBizjFtEcNW0iaLjbla4sqKRJFSo4avWWjxCXlx6ekbtCGP5DwpBLotekGiJ1kqM8gVK7gNXVAtyAErpnnqN5lV1D3s0nbzmztzqMSIx5FZ7OA/u3DRyxEd0ArICtxImbpdXU2jGXTqL/16RqLsT1h95sDboKgOpCtr0ab6Mcmz1MZTqYdsuc+FY944O+Z/5+8KhT201fbWH7cJeAkmKeW/5wc/o8GTl794QDsoGMMshhS3aM/eCvMJZ3SLfbcaV3bpWtKlQdOy7ehzMIihAN2GLMZAsx1G9kJOt7YwNe02CbDswt5/2Yx1V+WBvsmotKB+ujQF0li29cuYiyr4c4PjkksUsT7tME+aybFcyH4crEU9qb0+vAwqv7Qc2/LK6+s8D9F7QJoL6/SHt7Qc/wwqV2inmKQ5TfPZzI7i40Fjc49+aTs4eE0dpyUqE+9ZZ6hjOrKGrNEsYvuvPNTauVl1pJzO+yJMabm/5ZvN9FnjoBOB/vmGqO1MjMWOUJPbZUeTgsNpvi1iWSvkl0k30Pi59b5NuKVQYZ1qhLRtwijyh5743wflgRG3zjoYdGb+iLAIF8YwOwkB+UUKgasEuy4NoYdoW5ZDgmnvGlLaTS6kZ9P65f34+6R9iJB1luIUIrND9vTVldhKqL0IGsURGJ8dEGPpdw1OcHbWVzjwHf7DqmX9EYlEqbWX4P0J0ep9H/8V9LEL66b7qLUGXjgxjhuLa2K1D6777na4RfqxG7+VhAUCqJuOnUgmRpsQQsZOMgyi+Fx+EIKFkE7HxZa8Hp2O8Gn0KudGRGoS0cgp5vHFd7wCCK0ulVsV3UDTLUYZfID8HeHQkWSsfeCYh6whjQM2uyxAD9qFjr2IjE9VvNcGb/6uNDAoNk+IOjwdFFW2aURRok4AvIwsPOoSyCsKWz+5sMi8LWMykWeK9wVUzC3gs6UM3+dnX75dn267/L5LfUtGK16Vzp+0QXDVQDJohOyD5TL9DDe86aUUL+vQefe2XPGaD3/YuulREVM6WzqVROCV5z+9ZgbO9K4iGjNFi9PZLVtpqUWoPqTTILb19+7t06jPvR6uZCsIOtYVNxwKpnXUtP3gz6Oe8xHwiuk9ja+oux+fzWuverjBv7vIz32mRWkx34PeDoO4qkUlEkr0Zno6gnbfXUs8bIBLKf7qd6XZfaxPyYjj9U1aKbDn4L+xdU2kYQn6plcbr0xVtC0yXLqXEMZWVX3+TQjVXk0Xa0kRA7y1mjg9USzKlCtG6VUykIg7uTT+xYWShEJczdsPPpHh0hwzgHEMglnlmY56doWeOxa/aVBSucisfYuPe2KtDqJuxfTf6vvecgIwURjNTcKvp8oPg9z6iyt+sqIf0tNrJnOy4LgqIvqduuMpV3rubvVro3SVuwgEWvpsNgbtQUAoTuB5sLeDWahJ0QiVXaXqoQxn5GReYRh/cAIRGd1thlfsrDmGGT6dUmMstuNYgpQnFfdAw1RPb9/8JuNc/0sTU8i4L/525Mcy24WP3T4sa0xT5fvl24M2Q1cgEfCZt8HTTBeVReVrQB/RP0C4O95DUL+hjEMUwE6DKG8onOC4BRDjbQPwGHXy7BrVZdFVR73BC7a4hU/0FX2oKRw4tznje9NJ5wNMlzXvglYiHY71ZOem299hjJigr7CgImRwwFwui7nOFq67VWvAutWmKlfs4yfW9krbvY145Zlq7Xj7PgyVWQFeO5faJ1HaX+8he95V2CNZCM3b/XtkYgztEV1aednsz1ILYNNJ9hjf5AA4ikhfBn38SjQ7Z5XUnLFU2WqxbHbPp/3K7EyMNgLO3b4O25sjJZzNeEn5ti6suXsbqVhjCKBXeoXLjNBYFiD5/YSIE7HthacELf925RZzm2NiWnjJ2+phW9czaPMO7nmLjLqvhtvugY/UIXuQHBhQD1mhsFKYdr6PJGQW4enqbYEi+aYYQXJthM5jRMrGRD2wFkjnZ0mQnOx1j9PvIJO5bwqITE2LpU8PI0LBicPpqwOAMgxhLAhQ31GFwRY3Yt5X5sJ+xCG1o609nz25J0yloibNPuZXy/RSYDT0QoOvccpVbP4Vor0qExmsBkvHSG7JNYNNaGZnILvQsr4jBzpeLfUxopZCaQrVLzAwnUTfvUuCvCyhYH1MFLauQv87uPKg04Pev57FNmKD9BrK8NZfCm0Q6qDlsNW9fromQ5mHtmf3jaPcx6ce+7PRWtnsUsBQ3p7DZ7lCMK2eAkmKGLEOnUZ6p7cojBnZuZXObGLcURLHxEtBE6tuNRS2jC8AYq3LlbMkNOc8K0g4TfIAn+2Za5Nuvkv+a0hhN9g7C80tVdOFnj1l+k3RVwb8KwiuxEqGVefKDlut0PyIOnqwCKE2qkazMdMNjrP5Bvn97XutKZJFKeWkR/lQs0ILOXkHxHXF0LjxDGsBiQ0SsIMqEU7GxLjptQwGtnASFi3hqMXWfDM3GBhBLBVuNGPTta20YCp6dEcQbh/B7OvU14onK3zFXHXlYi4sW+tb/7j8Ktb91sp/b1xcwqmi7Z/4GpJZHvnq0SB+vmDGewCG5TTtpwOTLiHAzY84IHe+uUtQ2VLEtgjeOHksJfsFFOM1udPHEVw3tCN31TNV7LDsBKwTLp1wxL6HYelMVAwf8UpIVSiA+CDvnCAvd/oEdShknHdzk9iWKnwJPkfF5DjL3GEpXfrhPpYNC3vFsOwRbTQMy1VlzodG8Lx1Z50our4Y5FylYVM8aGCfzrch4V4Hea0GWgr52ZqU5FSkTIxPqD66toWrnNZ8ZdZowp+PdEoOFQYL7Z0J4ZfqyhOaOVsZhrRIVM8Yvs/gKG05tCAWrYdABLQZOw2d1US8Far3kdCWKNFbdBYj+cT2pW3TFBqBpq7davx7BnFTvOevJVhT8hcDEXgCmWqArpG4VWjSR1avCB8DkC4XiGjwHfAiCoEWXaIs32Vy58ZAjukoRpmDhHw81flhDR9iEKpPE/1wLWNyE0h7TsuQVRLphsWh21zVNAX223gC9rPODZse9CA84mfeMxYXm4MpbVfW/As4t4kYxIEkE0ESnuCl1XDOob7RSHVce9vDR4f5KMHhZNIAdz+uIak81hTXiBkjkfV3D65ytpBQs4BqlT0vK99TAlBFuRAKQOWyk69jm+CaOuxhmBqkW4hfYk4WVnNV/tjNgHlE0lkb3yGzL61thcb3Z3H326GpPIPRBRr6pHW+dY0kdFvlT746mHR/06EEO0f5zbj3KIDEUT27ctpcn/N+8r3GiYwBykgrAYjeMKhgxStCg0M9acC7gV144yoBxMNQ5CEdlcGdyjORDvqmIfB714zglIV7pU2Hf0Xsx5itHrAQuLXNC1MwY+8ASMnPVwTVE4nV6o2QeNCULTz0UZce6uBoOL1VtVkBV6s4jeTN9Rme0ci5XCuULhzeH6m+bHWT1DTheQz7f5MYImdAkhQkasw82SQWZcufbX6INNQ40inJAACTgsGcvLUW3bpQq/TtUdwDgjjf6DMxAtem76CByIKQcaabVYprUmMd3Kt1U7m7mH83W5GG3vLlTiisluo22FGc654kPaLjOdTiQeAOjlFhqG7K9xF3VLN1qPDMzSA/IRgkw7pUTCWkBTeNIXxiBRyL5j3maAtrbw40jF7NIa/nDVfNRv3D3JdsWy2W9vMq6zFGDxVgLs0mVkEdBkxjqXhnrmgZ7tdiCLUANQzFT6EedJy+7H30CZpH1WkiGgb+NdKNNO5Vqc0uavjO2ssDhzutqUakrPjoPzl0/yo3h8XUje7PDBQviKMrTW1pBAFQaTjM+Dk72Fv2I/0cQFFbLfvHaBRSjoR+MftJDaf+NjQs1Lp+hwxsn6dOHysHP8KWWfPyhwn8ZSWZGheT+XCAQX+OXliFY0WCIZgMe33nlIImee3b7faQnnTpx/aWQvUlZXrg6Eg93jSoOWZgmMnlihDjJ1Itr0+OqCOI6MUK2rzHu0G2fJPXlZB09ejLWJCJih02ppjPYoio1cjbDMA7nPcY8e/RXcgpulwL/cN5rxM/nwTXmDi2Pr+kfP5sgBamRG8TBWMnffGPdwh8WNCjM9akwuQTxUaMX+zRdSl8qzlqBmQEnBXAvAmp+wlyXxEn7UAQo0rJ71/UfcYl3PUp/kejAdujx0KGiUPt3yAXWI7J7XO6xV9CDVyi5PuNkV3/bleXUY/ydWEqRgMedXS1D3wmxyVifcfBqRJAlpB0QrMiRkJ8ot9K6SOOMyRz+cbtN1ouhV11wgkM3p5pThpfTnwVsZEI5faJ1s+lByacQqsoQ8IixJ1+X1xKgKmSuc4pbdtfSOy4SLAthBSg2rgHQGngORMVU0JS45oRtbHqG32EphPoOv1OodjvDwuuCZPhi/fXqzev07PNj29SP6muOBvWEMIl7xF2CrGEp34mslbq6mEBz5OQb82ucBx9vXjqKx9iyhmN3/Zk4BH61ZI/8lwSYhdPdVTs7UaJjPPNZl932hJVg7FA7cJ3U+kBpsdGpriXY+uK0hi3Nr5vIbVaUd5O6LZcuBFa/5GsUzpR/3Y2cuAAMEkWMMfifuInZaMZzF7fP8twsBo9V6y8kU0PQv6CuDL7o6WkJg+PsaOKcj9VAUfUeBblRK37TXrFiBkjqqDqagPSHaKkl8QvboNoNWUDHhjskQjYvgOQ/Cq2C4btThL5rdZtwZK4B15XCRHuc6dAK9780Knq1dvu91NImewfVw8yQWIrsxqkRarbvKVDHoYP2+XuAHIvuos6682TJtbVCLV478uyszTMzq+awCOyXwJWLP69p/4yuywTscGSDmdFWz8og/YPNuIrR+Wh5s+RO6psROUYAi6kMEzz4k5YmL6sbgOU4OsBh8bMpBz8iYtw6sGqSSjbUrH05HZf2I+UJbi3qtdLogbl9RREL6ft090orZ25VojX9oIKaXZbtHXf7MfUda+xWs0cDK0aaTQPA0gJD61abpyyEkpHuMPfja3CVZ2qdk/3fvg0kM5ZOg61OzCEsCDjqnfIFHnvqmxlt8ohi4k6qqWATrcktRIJ5234OKSoxaMMSikmtcy59ynrS0D7V7YXXH+4CttAGTUNarJmo/ZR61eRQeZtz4gycGK4h5ckh+IP955+4yQDOA0TMdduDIqjCN2WBlSJLeyqf8Cu9dcK4wsQWYdrYw8za/5dPoBY432QLQFENDk1CYXpfyH65YkCezF2VxbSoAP7R9LpUzRBTXZj6u+FzmYOtjsEtkdxWaPHv1Tu6v61kfLHGHNrX28ZJSEUXBASv4ff1Ox9BAH5cNSCEXaHXNmGOgicInS6b504XQgj6UnBCfe4kyzms8VJiG/mTNDM1jkIOJVv5jmJevjEf5qCD/kN5QkMnCYHP7nH6Lbiru2ZwrRdBkIaVFBqbCMK3kNL9JeIX0CpdvWnnqPJywpjxacpJZKt8cqWCTMBqShTRFr+obPMxspPirCy6/r7zU2MtWRdRFQnTb0wWviyIDlMMUQAcE5X0I3KsJc6xgVOBDJW3DeeI+MoVxRH1M794dAYi6YvmIdJbKnIo/1bAY5inGrGmtGT5MYHwFTL7FIeYt4ESbbUkEf0pK2RoD0lXK3koq5N88f/KBjfWI0sfIfYqVyOo3AAgB2brPhWkr8pFik9ckXFFE9a3jByXrtWKLpa3CLwL+//RYarBrEXA6AGMQ6/bXnU48rcg56dHmB6CscUwFCgat68+Z3zoaoLOABPYr7ZxjnEOxEQzIg7kgV9Fz6eFtjY+C6FjI8Z/82w47xkdPWv9wfgfHzTNyqzYH9UCWAVKpSSrZypIt8bUhNI89WN8HNj0vcvHik44R5jE13JUQs8nRE2bv6nDlxY9Gvc5OJArOnOpTih3kRI90FPLmIT7dyHKJd6kaeGMHhhWZgH7aYBAPQpZ3093GfCU+myc7XWihQr5+CYXlwfti4GPISGd12j14o9rAiDSWDpBWV0wERPpOTgPsg16Ub3KQTCGIfHSRSN5AH8/R0m9vHtlW/9hgKeGrhZixYzOThR/SN9+Rn1TIUh14+9OSsCq8bYSL7+ECZL+Ov7y3SHGYFesYYKe9W16X2EkWZtynQYwklRPaKlhWqCERagZjRutALZuheRidf8op7iSaQ5KkJG89qGRbhtLE6o8wRnZUO733y72Ii1O5EjogD7KlvJAU49Bk9pqnSnXIUBOpZrgyY4+KhzOKCf2ORNtJmqSEeMA8tcZHyhlwqCm6LqtF/z75JO7OvTKVyvsmfwmtY5edZPYPSco7Jp81V0UpYk5Ri+xpMtb/po8Im4ia/G+9wnMorjx9+708BdU9cNe7X5VHQrGU7pK7wQtkQgZQ/tNJr0GtL1bjbZmS9plCdFh5aqrWiBlqIWe59QlxzGRDZy/a0TAA+V8fydozuLy9cncl82DQRz6TLcVXL2ILeuA3mLl2bbGv5JoyHn70K4En1ZbRVrlo78lgsRSQ2CPmYruLsW4wpSdYrEXdOkn7eto7ERcSMeyNHO6SaOMEex/Kdmzmqg52Xz0L4+Gi3UmnnQ568T3+W2OAinwYsG8feVn54b5QtMHMyyQ38nc3qi6WDXD0j3HbHbegJvU78g+ocfJqAMWL8VuxcYgalGOepmsHjd00Iyqz0Ss2ubzgYUuBO4RgynvzoQgo93biFrk+G+6yqZMfyTS2UgBwPLBOPg8C3cOmTDSYbv5L2ZY5n1X5yMcZjblZiNmdhA11qCA0GHOVxBYB+4nLfK12q1aBDBolYtdbAXTGCrXfYjoTQF3ZJuPEMsx8+0P+RUdqjyXli7ADC3LGgtqVuhZDmFujJ1c7FV3QH4+9toNTxSr3CAo5p9Sjz9ORP+7QMWHN/coWNuq0f6v72F7ishsb529VdRl8aR5BuAaK+EYnS2NcV19zcT/4tCV/eLCqFVS5dVaR+evinw38NVxycZEUQFi/OwpXd3tzFs8L2hL8YwohTk9tkUQS7Ha07vv+fx+xvepcIhEoxiSFQJtiJnpApR/b/O/t7qWrxER7H4GRfizLyETcTKKPp4seA6p0LeG2Futs7k2a5cOdeuFcAc6HXyx57yb7MKSyry5ODLpasppiWkFXcep/24+SROlMnCNvzDy3EwGZmFTeQsJ2U2V794FO7pzYFRcE4re/EZ00Qbg4Y8UtOEUU+OTWbP2SJQjCyb72E29JswlEpBx/WOgOLU+5DdPEWtiR79MwQiEeLJ3AUDA2DxabvEVhNmDT+EwzeUOgeOhuQLBPs2Mb6d37Ynm15CvcelB1fhiTyLvjlplSw2IfSHizts42TMTpidmc5WazvKgmsODYMQLzn4EjuZG8sTA6VT8gqaKCBDpJGVIgKFFJoYD6kLle8tAEQjHuVjQNtRCBWT4ABrAw4jve5snSH/WMJ6WXFtAog820BgCI4mkibTXAuq78U0m1bY5u+2s/2xCKeHcp+GVm9y+UE4HtD4oF/QXMYVKgamZAUSr/il624XL/7xP3emuIpBj6fU3V1mkrG9mrRhmgScTVQDZJHkDKR7QeIu2NTuc98mnG2rnafyctOsCTpS2pUBMLjEEC9QenhOYYrqiq2P1UCTbOQZtdXTXUju4EYdHEac2KSH6aXBATX88xivzsAbzS5St+WM9adtsxwZ1gYe5IIkNJlPCeg+C1hdgFMIVFUMCsDp3h3iw9I0cZShsXr8cbbHt++0uWCyWG9VUqmMykISxwurTe1nBL28l9C24r+jCr9kI8ne3ZRPqFdrupyn/qqQhmBT7dR/xfFJpfWvrtzPB4T+lCzLcMg8iIoFIAyAqLH+rr8mJ5i/Ks1Dyi9Ff3upk7kug26zIyv+YmN5NP20mg7zY4TMflwBeCfLB2c1h+MgCis/XwUrLt3E9oDUGUQjZEclMuoBrT929ARXlDrkTP9BS+v7FmjB2fUAFW7AYHjtn6avwOPhXTGqCRmmxbLIF6IRkWezP/5IQM6B8XP/PBJ9StHh3FrSGfxD/IcIaPXDz8OI6kewhpC6UaufWZutXMwhIbJnt1msqxFIidMs7j3Amj8qri+WISVaGz5vm2mKjsWnL1eJDkMMJQoOwJAuhkXoxrXUqTphdFlECzb8jVSnmgabPxCexSl5KqtAsLdAIG9gGCmGeW+FMncuANmZQqsqgwQRRWDMeZjQTx5FkBuwX7zSLw/mcdFkqRhl514qDhOSG008fMIHeR59PTD5FTsArC5KM/pIeweI35DPd4+MixnLNzMcgHT1DRL3uo4vptbEeF0hCTxC+oEJlEcCkOeW3PCLtvPBsv8KrGlyUAyCfpn2WVoJ9/aTw5TXhkT4V1Kwa09CegktPjC9mIHo0dk03Vr+tMkCw+H2PZHz1sv0xDWG5E7qlZLmKc9NxNbelBnMHEdjFQtRyzOsp7gHk3cbirFKclrJlCOGUfHX79zt/ckPr7mPB+0pbZUOhUX4v9tJgY7XPsHfaJeUITQPiR011vBeK3T1Yvxteo5WBA9+srmNePyvCy7JypFbLZ2lu18L587rCEq6wPEgxpCn7CauVGWUgIBnnFV4Pa70mqasruxySlKq33FZXBtZO/o2Of6+H1rNYi7ypsVN5OFIbThOYGYD6AR/eOBq1Hd9Bm2wqI21WHZjRh5hWLKVL8ABquAJCHnqf4NNDs+grdrCNVYyH5QJYpilGqY3EBWQneceIk/LWfAXJbWI91V6fK8rO6RdhNAcyMgz0GbTGebA5QTyFKxk1FVxZMbsbE6Sm+MUyL2D1IVpTrrv2MSSEFHHI5Nsmi6SqbudRGVoYNJ/e7MNP1/i7grLweE+jyzp+dNRhxfyxlkl60ArSchunUVX3ka80IXYPZabdorsmXzzYvgmoiCFA7i8856HEBxeJX4Shtz8a7XF0RqoD0d6zQE90Lu7hzfbX/YxKAv90sa4x0SlwQhz4WbVKosOTUcVJsaQ69COGJE9zkWaVDz9/qqPqBwFkCJ8XY1D7nwAmgOE9qkIaJAUx2r0S9e2f3PiOfH4F6LkfVq+CfmRN0bQw3Blj54IL3q+Gxq1T93ubcigEtTX/9TuPigEdBEDRp+/X3XLlz1ohpCdCp7iqdJF4aQ1IQUlW/QLbR2SZCDd90mgpDLChQA4dTXT9CgC6SbK98WCEjObmGAXoILi6/lXR0MsGJKgNYs7AwSLC5oRs2dVAki/rLGoi/3dZW5te0YZ+Hxr5qpxhwkjJxvsX5iaBnHJcajtUDsmK1kR59nxdzHgmdXz6Omi2L0hr6yldNPJGz9rlWirOhobFFFIbjsC63H/9Gp7nImZeT5jIvV9NIRnFqPndiUoI1PCy+R6jbJOQXShtmNxltkG3t3JoG9MYTbWv9cL+A7fC0AvwO1REgahT2RlZG6WkKQUP/ZlAg3ozRaapjSbnbUnB/hhUTI0ucM44G6HYXZFnc2qZijv0IFf766UXS8w+cGSS/1xPLpjXQalVayIM3T2Ai9PpWFgvV0UYOOzSXAaFAOlLugHscThfpehVAX0IsYg0su+snzYyXN/egRpOWCIm5Um/q43JlsICFAsmvQGzQsICjdnVqZ9elWCGjBhAE8HE8/lM30AZL0ppwarPoGadrwed7TaNtHyB1IRBo13Hah06/t6YSsxPj8sBulZE0BzJgVvyQQbf9O2F5SvdfVfSTTOJOcflL4No4abFsW3FFdx54pCB0JnqQp/aTMPqiJmKLIdGmYgQ86lttFXdUkkiin9hk2fgPH818uZUI0RFFGZqR1V2oj0J0B1yehAHp2CEkjcNNVNNTcoCZWFEtx4Ihb/8f0T1Zurj5WIDe8s8wn2F/MWAP2zkiLa0v/5sTRKMhXwEc0Jz4vJO2mI4KfHI+M5zJx6a13P0vZRCD1aMtK3jPPZV+bjH6be3Einhc+ypA0kryLI4Ogxlwhakt+LvPwUXd+4ersuGNUFMO/xcrMlOU3+Gkut1prgAqKK+F6S0/BcXx3zWCZiEL6jbWfQzdd+bLiBIEsM4AT9PdVaQE6zijdKVBcN8tIzNpSAIyFtuari6/ymJ77f8BILgbXdfCcG31yvflsv+KSFO4sJKgWWGhxWl+Kx50t48/zz3FOGnHwhUjmL3jlmsGiAw7xUgqUW0BjtwSopkMsKpHlg/5Z3bUVhyZp8EE1lv1c2ItXD8Ma6bl8LlIMA3naLmEPFykXg1HgQhZX7iAQGvKR7diwcvhEcmeGgP1sUtei+m0BjpWLRHHTJKW7M468Z4cKX4L2IYeC8zNahz75bvR9k1cCGzR2ufApnK7lc2m882XWnH40ePST+kCG/UfzroPf7oO2EaVzPgmoUnbsFLxdzrsKDg5Z2XaRUYmoLsxHLhWIDDeD2F4cGLR0OxNiiwPf1lYkDf6GxXR9t+jKIVeaSkAwYoyk0OZwIS+DNIvgqWbS94azxa/G6uNYC7P1jJ4kFKtfP1Al8A4bBbviR3RJ5bBkgtQx4Xhij1EupNhm7ziWLaSotxbxEa0RxhXs2AlicOKXSo1+aZHfl1a2EI8W7Q2o/WxcqqDqviXPXVXTzo0iOwlSbKxD7PseYBWoCM+hUdZbn8QRnnFgBtQOQ64i7yOmICR+E0khA4/Ej9ygN4bTFTjEW7edotGXuCFeljQNLUS4MWE0SJleBuSRuixs53E5QO7S+WJaaRQLVx1s+F7magXePCndpoCFqbUYdcOerCS9TnB9pOIvoCWUAZmL/1ZLdXJvG/0Ivifm4CQIIP4UZ/ZmpYV3FrE2rHEgTRW2Mbi9mILpOeaVyytbmz5UhRE8OINwlEi3xvPfeiv4/y/zEzUvRzuOaRczzuPgMEGTcS5rYrVc4gXJzicWVt2BHkST/f2Ki3EomFm4af0IeueuUU3JcU3FKHAvxi/kEdZXHFJnfQRqo2Q2howbO4rtNzERRVtvU3QOzJ0ZR5z5SCDDCdNsdJX8ICwPsgMyXD14RqdKXcLzijmJTt5eMT3+tDn0Gf1145fmtDxrfzaRUSJnF7fntfKHGzhLVtvfk3dAt2j1BSESzMKdwReQ3lx5BHOFEcAjQVwXVrQMFsQNEB8Bvb7u3/OLEYsD3+86feTcCkwpqpTgrXMT7y6nffB5qpY6V/+ikdwd2yiZ3pjx4j58FSy1vLuwRdlYttpYrAzmworVnOvCtC1T7pyC2Z5sM2kla9xlztcW9ipWX4hfFvMtHvuy7RWA2JBC526D481bOkCQrli6ncS7796XhPRzbOKdoGhtF4VjtvNj1sgQv/0uTAlo5wOKVWFN/I9IHUfYF/v2Pi+HciBxs/nF7T5+14RtGT1cggpcDzSS9vsIYPr59tDKrbyZZRLlEhmY19HvCCNrX65HHG3kFEDzZz1aITNULdGKBMVUQS5ppArznlxrf+K/PaS3njUvkAFQYO0a/sLPf4LgwzO012YJrnvR4l6oS7OyMxcUPg00dxCI2U+RpJpYfOoMxinOnLGN42cYwrpotzjnYpBrHJGeHIE7054olNvBW+MiW8d974+D6mtj426ZdocGrQYkvi/rosJt32HQNlZw2CfN4qGVdjOITpK/u1AQR3IhRJ/exEIeWMlhRRIUKDFfWMRjdmKSf7MiUiyCmfRH+4P+8VV+GToZRD8P1zKc2ieLigszgCxPBphthZ+OiqoU4p2mlMYJU33DI1nfg06t/qi0aMtteOCrSDo8tfcqVNy2UeGIAiyoRvbYXYyPsADljyRsGF1OgPlUKcDL1OnbsTZiYFSMpP/hNgjQcjLX1GLwb5JpVO4mWazIVHgBdfUlWoknI6NwrcdQ8g95syLLK3wR85hd6VFUUq93OuQgBXxsTv9HJfC+oT8MM9pnvYglWAYgl7DcldqiCombUqKsNkKNg1lD3wbTafS3rkoBaCnHA0IwXQmLzYeFNvba6yMthlAbqLwL5eHLmn25RRlTmqltULuf2jI7EMsOcrdWpSFStsL3RLdKPzUofVd/2I9+3fpg1NLS74hyucAgAl/wmCQLQjEU5FSTMx9NjFs4BL4RzljWbO+T9SqMeLzn35AYf7/ukP6aBcjirM2vS6yHoAqwEApu5lyNki0giyIx3JAyFK6Aik+EDFYFI2dMJnCuS2yug9pC046nvX15tWeXPoYXzDtErak4h6QaQ0osEwJlrLOt8/rTMXNW9Bi8sQ8cjab9MD2WOvRkyHeMAJIzdU7U5B0tohUXJAxnYU7q6eIujgxFoZcvt0XRYPfk4TITAlXbf5XuvMcN0MMg/oA2URsXc//f0ww7yvfzTwcCznMLmWAM/gjpfabH2Za2jAqnBkUmpojCVjrfoHH63/XE+8o4/Ac6/G0kfj3Usft2EML0bhQRxJin7Xv2j7yb7MHlYKnKa6yndjOmm7pmCBHL3A4eWHSwE0QQ/oIoOUR2vuVhGYAVoGp2D4uxIBig/urqxYRyKYEjoZblc4+6jnG385H4BFQdGxcv3Oiam8nvU2reSd+4pzX5vVWI9sRplVrp9uYsGIj6aKD1j9T85eojmX/+ZaHcmqmIdj3mKoCEv2yp6qF0ke3166OTcIoGvSrQc1jWZz2fPKqMG/rUF1cvll88huRQwbwxuiPPPEMwKyY/1G2f5ysq1hqrDjQZ8qkLeQWa857cCm1A9f4QsaMFbuzepRruvYZLm6MVBV+8CyajZ0rgsO7/a9TPgDVOsmobRroYjJmgeXHxr/CrVdS0zoikUSQXrUfLxW1jCI7AHX5StZ7ebldspyMvsAzTCZdHWYQCP3MEQcuKS5c7YJ5wHyRSRH4rHztIhOzclVqY7sV+lyrMDkGyEDBTkKIF7b5UX34sLLTSTWYcBrRdyz/2BiKLvuFeH8tQgUu5UjQ783XjsTEqSBiNdRv40ut/cfLdWEL5G/z5CYKOaE3tPGFvefKdnHeLiyKCZOFfsITfboQk9OyqiGshC3D6quK/F0yQpw6/EMZd6847KQu2238Tig8ahiTVqbcLs07xXFcqQQx976oIeTdasl9WsE53HhauAzdMGIWZjXM23xbWf4ojFMK+OPTpbD4GC6oRHCFYJ6vSDr+WVEeXpUIYwn1oJyLrVp9UpH4L+TcNMpmUZ5SyLDontvpnQpd9Uu6lI4AGVMxyfBMBP+sahEJjB4/zf163PqrHbuLiddI2NCn3nWHT6jb7g/Z0acTT02EGYpaEtMiUNmG7/I0yIhnM32OJvwfO2SXFg==');

// Signature verification
$__PK  = base64_decode('rE75M1Ru3m9tKb2dc9rdskMDAQL/P9dxBMqVC0F+3jw=');
$__SIG = base64_decode('bAZnIUtmUHSkmJ26P6IaS27FKGBdNhcjvIHKwCHK7rUGWZdX2NGfRY0UGPFuDIR0tRqRkcmyMpg/JUmv1/BeAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
