<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["SGBz4MzsxH0=","krmWnlAPnH0=","UUHVcNMi1xI=","iqpkQJ7xjlg="]', true);
$__MASKS = json_decode('["tbQA5yONhwk=","+Swn1SfFRkk=","PA04e5rvdZE=","\/knZavB4koI="]', true);
$__ROT   = json_decode('[2,2,4,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('KdmXKnu+AyYt/PWboHOPRiIG1J0ggv98');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2xhbmRpbmctcGFnZXMvbW9kdWxlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('p3fA0OKkYrE39cU9qVIXgWkeTVTUcTlHYksZw0dolPo=');
$__SIG = base64_decode('S67FxoRcvj6w9fv4Uqsf5HiMcFGT9NFz+x2Hbfu/UUAVL1f6J+W6on4leHiyfkCdcARyqM3Kq8EsoEE2/D5xBw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
