<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["PIXu8kGvGeg=","E0r893kgZhg=","NJLds8ywPcU=","OYCzdF+zFxs="]', true);
$__MASKS = json_decode('["hq3QLwlsHNE=","PYGQQ9q\/cAo=","VALLgm\/Dkvc=","ecMxcINl\/yU="]', true);
$__ROT   = json_decode('[2,2,3,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('kIFsPx3kMyqkeJerS8dmY8MB6rjdVubS');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2dsb2JhbC1jbGFzc2VzL2dsb2JhbC1jbGFzc2VzLXJlc3QtYXBpLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('8FxkHwekqG5DvQbkcAw43Cn3730QA2FyCCA48OCCc7Q=');
$__SIG = base64_decode('goz6Br7vRQWAefvPX6/y33O1HLGSk+Cz0KSJgQr/ZyrYxBrKi94enrBk4wlRsBoxWmd9Rnn8WN07HM8Lig8pDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
