<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["rqm7Iid7Cmw=","XzWFAs7CvQA=","90aKI0G2v0A=","LHKgfjcPD4E="]', true);
$__MASKS = json_decode('["2smckDx9OtA=","4zovERJ2oAc=","NHFNAL9+pwQ=","RuOqL77z+9Q="]', true);
$__ROT   = json_decode('[2,2,3,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('OwWQFjbAgWO1fHGs8yA8FvwE9KdUoaf7');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2Zsb2F0aW5nLWJ1dHRvbnMvbW9kdWxlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('6BlzUcSHIGVzsovWD9iGDuCDrK629cpm6CL2RNswiF8=');
$__SIG = base64_decode('yhtkTJU0HM0hiWVJC4bJGhMTwsQSmX2XPiYNj7PiAr3Cbhflr9WMmsAn/sbsq3UQGHAr73mf0ijtCDxkrAqMCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
