<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["5GwhHQ\/AH54=","iA8wzKpa9S0=","0RM1ACp7LGY=","T8A8OwD\/Jk4="]', true);
$__MASKS = json_decode('["Jeafp9ntzvo=","4mHDCAgi1CM=","bny\/YKDt\/gk=","RcbRCmqSboo="]', true);
$__ROT   = json_decode('[4,5,4,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('Lv+0iJoHchXWKYjhKiLzR5MEEO4w/lpr');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2Zsb2F0aW5nLWJ1dHRvbnMvZG9jdW1lbnRzL2Zsb2F0aW5nLWJ1dHRvbnMucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('V5JRf683hZboEgKohTpHZcnQYx3/gP1VtYDqm9tDBu4=');
$__SIG = base64_decode('Vzdddf+oqlADmmz1k98A0c8k/Dhoo5cS4+ywf42cuQTaBKhUY5xE3FnmC87Yya8FRgGcW6jZf8ES1SVceAiPBA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
