<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["AB+D549qr7M=","qEhXzcZMSK8=","Ark9poGiR5I=","hVS+Fx4rNW4="]', true);
$__MASKS = json_decode('["aNTg2BdPKRc=","bks0laAM04A=","8HQW+A6HB3Y=","FusjyXS4f7E="]', true);
$__ROT   = json_decode('[7,5,2,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('Z4/JXEGtkpPZG52k44LbZsWVmhcqmeg1');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2NvbnRhaW5lci1jb252ZXJ0ZXIvbW9kdWxlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('nLIAqL/fyzN6PjNYTOo1CAO0yYsJlJSFhUJpU760X1o=');
$__SIG = base64_decode('xiEg55IbYEXWcoFQkAAGy4VxZR+9dgfmB3HFvRLbDBuMQMut0/puol6C8gO55rCkLrqaV8txHIHGwnR8SIuMCA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
