<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["guW2K5L2vAU=","9Qg6DbXKhxM=","wK29v4HOeBA=","uzVJRgr7sGo="]', true);
$__MASKS = json_decode('["js4FksUJ0A8=","ymE7KU2fAVo=","6vz\/y\/3zjTU=","Ai0MxJKGdIA="]', true);
$__ROT   = json_decode('[1,1,5,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('+58VpOPB2ZtgIkVYon1n3hdlrhE8wTp0');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2F0b21pYy13aWRnZXRzL3N0eWxlcy9zdHlsZS1zY2hlbWEucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('IBA9X/dg7PGQ8V25dBHACzbSHnQR1JVNek1mDoaEd14=');
$__SIG = base64_decode('4j7WLlKXNWuTBBAR8OxMEn2J1wT3h+R1sJzWMTQnHZbWFz/uKC1ucglojFl1XxcjQtQ1gKyjwKs14nHy5LcHCw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
