<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["MrW\/DTFZw90=","Az+r2LXj2MQ=","ReOzirO\/Q2Y=","BJKEd7tM7Js="]', true);
$__MASKS = json_decode('["Z5J9IgPtkqY=","3QswkBDwT\/I=","gRoHDqvDjfQ=","D3CvkFsrMzg="]', true);
$__ROT   = json_decode('[4,1,5,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('kxESzibPtRxVqlx8YloUotgsvkSfvKGE');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2F0b21pYy13aWRnZXRzL3Byb3AtdHlwZXMvdW5pb24tcHJvcC10eXBlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('Q8dh+Ln9eg2fUSJgfeloHobDEwZDlCE0/RQGCx5gRN8=');
$__SIG = base64_decode('+gGVHM4RR3nV/5deUjm9gFQy+yJB5mu3wJ9DUYl8RpRuUUvgfn5brLLyRwQWbAyYYSzP1WRtSiYXbmcP6a9KAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
