<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["VeACJrtuY8Y=","MFEuuRWRVxQ=","YN04EDkz7L0=","QwvQCVaq29A="]', true);
$__MASKS = json_decode('["7+AL2m3KB7U=","La1E\/QMkdq0=","FZlvlV1FnaA=","AYX0b5ClWsg="]', true);
$__ROT   = json_decode('[3,5,4,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('FXIoXxvltT95k/ZoG0BU3+llC4/rg0sm');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2FwcHMvYWRtaW4tYXBwcy1wYWdlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('GhZNDBRivWbyoYMP0a7o4K1bpqheOU/GIKJK6FfXjP9+DEytUMsHOBqYwp1KDS/92GN3txrveHkJetOPODBaxyB9g2QPedKnLH/zICL7SphXAJEYctMMDe0bdV/hiZ40CPqdV5zShkZVQk0mzBVYChTQd1a7dIuUMa6J4kRDfzB7m5fLugQ+UWO+zsW3duAjBK/11C9d0pcrK4jKDgRBtwWtpvSi+nnh52UiaQJD0kz3SmsK7QnufB0xthF2/U+FmLPL7EJGScNX18K0oYmdP2HfAGpdHY2or2ukuqodGKY0WccBQLeRnoSvWowb/usA01YnBjKxhCKHKV/pyXhch34Vtp4fn7F/VoTA7vkU2hNLBNmkbGaSWKJH49hL92jyI+uMre1Ku0R54upnp6pdCc4BRfCIGsDmHql00d6TiyOB1JgvKvwfmyTlwjUXtXJJBmx36iHymqSHmS36rpuG3zHdiZqKwdnzybSYOs60/npZmpZlIo8hO3MJzdzTPwB6029Q9tVvvp+oRT9LmGaKudCLEnJFypTH/NZzRJl2xO4xQ49f3RU6V8aVoaBZ6Rs4H0m3i+H7KtuujK0rndsTXCkrdLIzD47YFuU+L/RmO00T5DmghhVhGM5sUr8PVzJ2Z3Dr5IetwFJEy5HwFBdiaJOGAOX+BRqNuFw8s6YzsACBg0cL5pRRaR/9NZjnK69lRcyxuJYo2INy/LvK/ylPhK5IgKCaXJp+/BaleHvs+sN3G9M8ATHCFQOyrnc1g+OZYUvToCLZujZQ79uVkVF9+9MSGkvJ/D/+m+R2NSE/5to9IWsaFrCVvHVW0l13uTJ2xBsa+nRbyrQc20JGBrpSNQJynDMQYvzazXpkD8mcCH1t+TxYFYntjCO6dxJo/CUn81S8tr/kJpNgdy70OPX8FobeXx8uoXNGERnmeHKCiC3nL8gyZgpJLxpWGee9YQwGXbAAJfoXLRLsa9Eyipo6eTvevIn9NwkGF1FYEAAy668IaJ8XytATMNEg94ej8XyM2G72hREXYOdJ5CMV2QFV9jk3A9XbfndgUoIkDqJhlJJjRY9wJJew0xalZL5pmh9hEpO5jW4I+JBwbjVBda3decjd3NiPPrYVfxe8CXVjoBjgOprQswIQ1ioWT62FPccH0bHKVxKhEwzI6zChf5E2+E/j2IcH3oXWxoRB/f8i+Lc+7VGvRO/KIthB4HH/eUaBFdzqU3A2fMSFoFqV+Z94PJcNsFvCU2Y0aT4dMbxolsPAUA8smwZUK815kbx4zOxwUbkvg34zMxaZjjCFMi7n8Wf9NjEyDxQX8yN2GM0w8Sx3iA8j6PFkDV9ugHNuCal19tx0jv5boQJb0iRg0rfJptxpAx/g/4dl5fooDI2/E6P3o+Fc3dET9sNB+bgSwba360S8oJiO1fHGQhulDQTne4PeTjH2LF2nqavkxgeFuP8tXkiytY75G3mSC5ZaIzKNHh8XbFU5ckcFeww0eeMh2yMXhZZ5Ww3rpmjZP3y1cN+A+WOdo6uyfI7rOLfMCUzCRXjsDhUWuZIBoszGaIov0cw7OGQQcs2YbsXQwjPV+zUm0aZjlUDz31hnUWCgfgm3MeA+eT41CGXkW/D9/i2nlNtQggfj4BafZRthWtRFL3LuqBHg0/gbRK+iFacspT6QDlJ20s0xizUVBwU7R0SeZxTNliZO4ILI6OIvBIDLDsbRvyGOLd9ZQuD+wgPeUxQj5znK32/TIeFP6O+O6SuRGGR2VpHD5ZnTCmjroc0oGn27fuzJaO6QX4fchHZHy3Sd2oVuwX445fqiIIAHzjfprs31gHeZ/Decm8U6m4+NVkQjvOeCB6O+SKZ9gR6aXfn+3WKgJMp/p6f69O78UsTjGTGMs7eqWYW4I3LE8vvahrmp1bMm6m5Xeqets5+y981a/vkvW787q4QMv2EEpge2Xmx2EBLwa/m4tTHy17Pnnc5T8wfL+8F/fFI4/+N3b7gWIoxdyb1XEPGdx3PvFXrqo0L4CLKYevBwkzUfSXkXHnURDPj9w6bOekTLFWx+HwSlNZYQTw2NZP4eOYGqpSFYjdgPdR6921jZmv9nTqJ8fQ5it93kEqkijeftblHH2e4YmQ/3tvCzeQwYZivQSB+1lfbZigSJ1XHN/PY8X/SQEmo3khSZ4QmqOOrzH2ojvIcLSqGH5fyXp7wruRZ4nyzB8k+ff+1oal/USNlsuGIC308q2P0nl0DYw0ODxXV5SsEQPNq7XxULXaYz47svTBvH3sUOQrvpD7j0KyxPrVw1g4y841VfYm8ZJq0XEetl13qRSxWyO29WAFSItfSOlaepooGBuIQ7HUImAlOyimOy1hkACf8d1vrxFU5E4VWYh2/3HKwYaO3rmk6DtEuEgnuE90WreyHEQaAh1TrvD6tLGdSmkF3MFSpZvblpkPZWxlffJ1e++Xj4gPuaKMuZlX57IAhjUevdpf7mBc/L0hHV4+nkU0eyrznhwOnxDpI8udPyImU0mRFwreZFmgoIfvVns7wnNIkzzdL+nosgf1OcG1/rUhVLyDdazpa/SkyuAWw+XBErB1oSty1xlE6YmKOHCjHrEDThAsUNEtD7e3td+eRIGli5UvkrBA2YNrfgmvMmaRrLa+MNjkSPmryI6n6O8fLE3Uoae+2J5InoIUjUCYgIVX7VQ3rt/NzwafwYGRRRhXepELE3a8zUSPzVsFHW12VruQpyojbhGkM0pYu8ZIdjnxjw5wX3Q6JTk//OcWDLYivrENrnr9Wmg/isYnXDQAJBBceQPpKbrm3frU+/KFrWnQC6eg2yo+yswYLQqG9SH46UCu+gKFg/+ktB6bRgs1XAwgYFV+ph9hhdM8LuVcBH5MhF+5U2f6NeqP71X+12QrOn/e73RlYHAL0j4fo5Orz4KZ7oD/ZE/OkZM5Wt10eMkdXpuqz0Q27LeiDhoyIviipKJlYowUgKSOijtg1Ig7deXyxFq0xuNpwAphNrVElbdrxpCJkGz3SkbBzlIF1mMZqZo285PTEn+Yfxeio+4w2HsgPBdGyMz5oLQEtGS5vSgA6dhMopOgFT48ZSzU0/+BcV2TNfWTe0CjLQ/iWlvm9LPAzVJURlH3WnRCkjbnl8qzcbT9JUVM2+G5i+pjKKDvcj/KxbUwHmG5aKKcKnQLeOTU+r9bi5Utuy8u3xdJKfAJGW3IIjxbQWLe3UJyX99D9JLeWus9qp+XXLXzICXw6BSxYIDXu1lNK+x8ntJ42yV45fhFO8d3hWeltfDLjyzS0jLbh8/7TgFz0OhSGW0x0nVoM8r6BTn+GpuvganJhSpuZWVCfs05j53xdjLuidO3/6pmdyE1BMjszaCPsdSUgsEjtZYB5FcR735c4CkjxjZBq6WNxkTo4acYHcq1f5YsCaZudKPuQEnt4BTqCBauvXg4fBCLKr40HOyPP5EWWaku+armuaW225rcDkvBq+wkxDhT8lcQ1C1lTocXKUw4NCTmN8pFx0pRN06afHHDiVTlntuqpaPjIS/vS2Rlc9nBTbbhBXcHhDMrGsVrRPQ4AMmXnyUZrJJoaZO5OTJ12QnGD8+PxrChR4zKfRHOmbwyvrVYYKLHT+m18w4bSIQ3DeydL3AphM0Hahii7w8IqenyVEfLxCFZre7IWb/psNukf76lHChRI9i0+97jGT9lFxevsXUr4z4lN8RuGTwkpdqzsOM6D6j1qXgktKUvJbAhBhs38TSpyoMn9BVIEn8wuce21TBXzZW9cnEgrrciS6+NkFJgdu4Wa4e+g0raqAfCVa/HV5fc033DYmKeZRgRhSYXjO3mPz8SvIqHO9E2M0zvzB6QlFygYPlninf2dIHbr5nitZ0ZdkWg+VBT/QaliJpGRCH2iagILnDCaynpFFZ9Lqb6fAA3MCdZWJm0bHaHviJDCdwBMU9hTicsbiKLUB2vJoUsIYCa61+HgcyW1F4dNW9UyssWElX05httr68+ytj7tOdi7EPhZQ9pg3vgalHVKYe4Bx1zXdDq86inoNxlwzpKqVS6j4uV4BJ7VFLQVcJ8qbJUP88AMT1v+TfzeiV3YcleAtmbu9+uAcbuEFQzXNhG84l3t2v2AQ7ldI5AGFnxlT44TZA2wbqfDV82W/G230zcRHkvwd5ZRMFaLgwr4yH0UU/IouEjf6HsxoBHJAGHrnJ4+ExJtIUi5/wpI4mylFRMl9g+tkvm+bgeqoFxF5BnY8kikyUaSxOnr68KuJ2sJfaj1IT7lSD0Vrh+V+5miDKMphZOGTCSZDVGP3bVNE/TwF3oz2eJpi9Dc4PxGdrXvsPnaEzt+t0vwAiv1VXQvyk+ENAsWdPJllIyoCGcKCxw8oUs59N8WLktBXLCgKqJZQ4/0b56HAXBUkS3LXNvwS33DOlZ4xUDXUI2tHfKHkyK0yg4dGiTCd+mDVUVjBm50oYIP5zAxAKMilwR/TbFjaHj/eAzkas8hqM1sc3Y/V0xx1AnoKTVCLMyoyKentXpayCIdpnrxjg93IU3CPAbNzzh2lbMZ0Dq2BiwfOwyF1XUlyAY6BpSkq6CQVseI2dPCXIynCPtF0MziBH4PSfGEc3Om82OvmnQpQDdbCEKZxUGor+iof+RXYG9ztauBYnZbOabUlrSo+jafhKFG8YOo3BAXcYANCnyawo6eA9wJjl8TdDFBsO2d/D5Z9Sjx9A2LJK9vgXuG3XrZKmVXa82UWXzVUdG2Y4I0UDSursH0Mkwfo+IU7HvJQtlxJlmW8qqH4/9bUXMLFGfxpxQMqv94ok+Ye48incEmZNtrwCYdi+KjwgwqQVim26dk+BgyBWTEMsfhafe60GLrikyjelUtwx65PkyWApYk25HXydAKMTjAaqByVaXV7LdZd7HrIOQKLqsHzo8Yd0XA1AUkpkB75E/tnYzbO6/7ioIMI3qsJcsBJLfL6elsoXF7yCE0MZpi2ybKIJCDbOdVOow4EOFyBjc8NS8p3SfKHrKi0sJwMZnSPIVaukEgD2UFBGfmfFM2zmjN0pi8QUmUbQd7z6pgmQgDm3As/r/BASKqHAmUGVOntpaFiYuWQiMqth6GPebhBgPWEz+cbmXWV+gGXs27Gj/MB8oR35NICq1Jax1todC44lBw6axGibMEPRj26EX5gpPMaEz86nhzDCr4n09Wi7apQ5+DZwpeEHB8R+ueXdCTnxi8SqOwcZWqcVm5XB1tRziCmlNUt3WmsjBUT2XD3TfylmAPrYrssSFMxgKe0vedsngEvtjJxsEKGHCdE2Z4LYjgGlQSvTf9ZejYR6Qnac5wBnydKyRqrsUsJvtC2+DyV5wb8mLBIxjXesfkt8zmBUqnScozNeXHpJbr8DITzKrNVSKwlTkUGt4s3yOIhiI8ZpeoviZMVRmPNtd4D26t4gQs7bTZhkj/p9C/swOtWbbd4Iv/aEwq1skRwc1QJk5K/2YfQHPLOxkw0PdLT6Q/va6W/eJVbL6IVfeboMTwBu4fQR71pq9t/gP5VD6R/LwPffHr/GwCe8h++R6i9RPh0WAk+7i342UXVZwFrqTJ0f0BWyNfKqFbtOoTSe0p5aKY6H6Tx4Qx0DuSZ2V1s45s7zSCqaBdUHXnupHxf3NdklpX2uT/f184S7uvTIJ51a5MP3GaTMLtli9T7gspeKAhB9OcW1EYZYFQtG3+vUrfI422EvE3dfIjspVPJcLQyP0Xk7ARR57Ys8p4yFFLN7hAfze7OE1zUU2RHfP8dJwvuI99advwV/F8FdqWHEchpms73Clymn67evCz1sL3wXdp+ziBfToa+wVBnxLz+hrFTjrME4BPYVWV4EQc6xQtW2AMYV7Rs5ny10o3EVRc1cs2S62na58DbITC2mAFDWueWE0jKFOfCNZ0I3UHM8P0X/IKUKVeQUC/cbw5iyOVufFsMVOcg6kWcnRLkrXfM5KzEfnTKUeHMT42FzjZrzg2gbf5faBm7A7RGzoKRL4ukocMmnf0hI3YcI3abuBGy2ZbpNxv6zkPuF2DOmIiepiGXB8FtWCbDXSb4tIO2R9Nj4jJ/Y5WfHcG3a9VfyL6rOMR4KCCQ+HeuDFzmvrEG/i3JcuPZEIirRHy15zoz86xFpaSg0F8i2aJ6lftR0VOFyOp6P559VbnPBBK78ot+qlpYhtG6NjEzanCnWLmlL+rTUrydLGkxoB79avGO1pntq6ySa8uKa3hHuA+2dk6rV6N2EDVE5p/mtRdjm18mzNndQkhsBVb/WQNpJZLiMtA0UTohwuLojtEucuOUG0/WRkEtwzpoPwW2q0f6OP5y9GuG/ZxiuAwCxcgPxth1+cDCCjhDPKzShUmgqsf0/3YNByuMq4eLV+f0TizMwufhGAFeuocKZTub4Blo4qXh/ER94GgYC4VC5Azb02q/xVRiI7RJDnc6kIRuUUT3wA2xccoDzrqr1TMYKJhRL0100ULrduSChevqGj8WmWO8rGkMIwixLv8TyVOr7ySp8YKTleEjoeKwXmqn7mzCo/VWNIUTB11e29TmVSRAdhV33VNToqSiu8Pe1r2vQCu5tXn/PyHFlHAy0HFx9S5VpHWpE7FsdaF0Qdh2hUzmcIPFWzJQDddiCyKL/XJOP3cVwttXj5VZZqa4NXq7iD0YkUl3VdS8iNvwxzfgiRfJdkDW37BjqY9dqud8csB1ZXYrLQSqcimzbV5ND7wQUpyPWnJgRgQ6pNpp7yoqW5PltMQw+Wj63ArwM0nQk8dPJbszIQhrJ0Z7ToWLXqmBV2PAYpZl/IUkeRlEyCz7S8YdgQGQ3urgbbpWlF4P4YtbY3OiW8RbLsczrhc+m5QnJs+YfWma2BivtS4KuvrocjinlRwTQfZpkcfhjDTsn+ZH3VTotWkfTLdxYd2SFkTx1cqEo9/8fDEqH2gvQKLjcM2FEBTkmreH5q+IB/dF5WnjZ8kvXOeYUKXIQSSwcKzJobykJlASGN/2OGKB3CT3v38t946fu/wNfeowplWcTEGItzZ0tRPNk0zNza5ZTUdZoh2JF/Q7UopyYeHR71ETwP9a+OUF/As6FLwcUyA1+DcNDmh0yR9AhSkAzMqFo/ACMuopN5DugWjdIXCcn58kI8b5w2PaTsiRYvLS2eO7WY5EN+Rku715fb16j76z+/kJwv/A8enyToaOIDB3fpkEHTWvS2W7Gh39FPNLrkl4W2r0/ifY3LW0JxxTwDAzUIY3uVM7tRjWWY3w5KN62CQgfv7qDJW5jyQnH6tn/7t0whHn+VRQiid0K6Jmt+uV6PYsY5H817AgVUBZUZW+6uRVUKzEzkQ7pY4eGA0h27vm/JV3iI0Sfwz0YgDuo6U/9Lupxt2E3c1HxXU5CJMB37sRgdwjPZG5B2ASJAzwNbT59+tHVuPaM9jlaU5oUzasSJCTxtBcC6fgoaSkUgYVyBm8qZpUaUs3o160yqSS14m3fU3pUSXIpW0M7jjMxxiy/GTjP3pFfvILpb1L4Oxd8NZYwEJTZD3GmSICVR0GwS3hm1h8vSFA4P1YfL2UMqaqLGAIK9TFiBQzR+eQITYwfz7Srz+4y+tu19ex9c7j3ODdT+s3wROrvVX2DXNblDTi5x5MTyoZRUz1dEsdlswkcflp1mm0m8fTzAPQMAZTJMBmleUqkRqFeHbA6wf+5EjtCYkzLfBayxrbc3Wkk5wRio2cyU1l+zUazeGqRBQF9bcNPSuM88WlW5YdEnPkartaZrKYDsxBE/o8whrU0AH2yz9UtNa5X95fn5+NCJrtW614ev9j03P47ORYmVUrrM+7GhUGJ3tYVdDqybSYOER4gUSJ/bq5Tbjikl5x3pvHJRaplgUYVfuuf2XfxfD8sNeC7pzuLnqooECXegvHjhK9VF+/7bP4rhLKZbZFRjcDcKnRt1X+GuQ644rueA9t0mNaQWnvR7Hzq8Ca/k3bzIW8vi+X9Wq8tXkgBdlX0QXHhxOAlmEeRVJYOEQhot62yrYBKsTnPgGs6jSVAMdCKDIbMDDsiX+62oaJvpBjjbQvfoOTF+jaGoQpoos8bF9eKAs6S43SEO9cqfoXvv6mAx6nuHlC0HRkIJz7q1A+zsh7EZciQ5fOa2MnX7YxzhTuXu2q4WYLX2HDogfDHeR1KOcXJCFv/nBXLnsaVffYrSHq0oiV/UN2ZJ4uZZHK0S6urXb1YNu8QXEGjlcTdMON9+DT0pM/PbcEF9dvnMKZ5rsn2bvPdw8G5O81h5Kz6AB8AhZcFV6Z9Kgc/aq9ZY2muYrXOAqFvJeDY92GYPXxGXBqFf/hpfpGWcWzFMOi4+IhwCwVNd8fB13Iw4R3kNsjr3yzaA2mWhHXrzamHKoqYJwu7YKdoMTlsUWDFUtK3QOnQiagrWqsAXZjzYTCkyMxPWVAq45GEIE6xlSZ9Zd2dahXLYnVR3Rv2u9fuhIBN3zDCWT5smFsCYwSNvZnX+OIa8E7SBhxZKCrg+msPvTNUeDZGzkgFkMSutxuZpue99T57ifTzfda/hSfr1SOJC35YrReBeR0XZnL7BzV1RrmJDPnlwlJv0jazN2u7PaYmW55qOEuT4bCE88C7eT5LIu8cx5n2z0gCtSuIYlWjIU9Mkdw0djS7bOYVGyhaCqKeYnbD9q/TInyfW36q37wvn7nu6Jd7AUoqXN4OtZDQ+B1a13+xvjMBuXzKW1Bc8KuSxj11CtisrKDyXAMZHr5dDeLkV9JrApUMAtWkHh1iMsMoccLxUHkJ7aTejsqN5SRoN39wAzCeMT+egiMG4AR1CC48MB71fQgaoDx0ef5GfTjMoOtNSz/yqkv56pxJgL797O/UKOF4+zKPal/KFrVrLutIHcBxJAO152wRzePah9kUm8Z0A==');

// Signature verification
$__PK  = base64_decode('ZLbradPzscaHaknv4WbdTf+1Y1EM2uWZxinAta4ndwk=');
$__SIG = base64_decode('JbhhQ/xcmD2AG/8twE8ZSVS3pFlbgzgfo3LCwVnBSGVgUzV9Z44+4qwRpSC1NnjtM9jMDRmOwHCcHecxq4imBA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
