<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["KVYfjwELapk=","7RqpmJgoo7c=","FSIXPo6B8v4=","9MzTPOj9fUM="]', true);
$__MASKS = json_decode('["2rnokbA5nJQ=","ic1R6VXZqCs=","v2XA8QmziQM=","K2nAzfNS1CY="]', true);
$__ROT   = json_decode('[7,5,1,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('th3+6+AX8vc9FZP4Bxt6ecazwOfRDe6p');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9tb2R1bGVzL2FpL3NpdGUtcGxhbm5lci1jb25uZWN0L3ZpZXcucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('7Z7Yb/dYarfhJVTCOFIv5mzVeILgsA7RsgTuQi7Bw0I=');
$__SIG = base64_decode('1gTxRNOMODFRGXy7zCm4qJwQCLhbQv5P2+UKUnqFF/pibZA2HqObqytQBkC8iBbc0KhYGVxjsG0ieSe7dPRzDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
