<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["Ja0aByQ9GkA=","P6RtQwkg9EY=","69LyqunUJzI=","CZQjnsfuqkA="]', true);
$__MASKS = json_decode('["ZCkoKN+wmA0=","+P0CEzC9iYs=","\/H57TJo7jhw=","35dJ\/YOCRHs="]', true);
$__ROT   = json_decode('[2,5,3,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('iXrdfYoDUrTxz+JyF8Bm95sEL5XfiyR8');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3dvcmRwcmVzcy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('HHcyl/FTqHqXpcyfa+uDYq/rSiqPmiXuJSI+w48IZa0=');
$__SIG = base64_decode('RdrifHPkV020wdY5PtiuIN/HRdxzO1zkVY2ry9dq77IWQuD75AVGEQng2iT0iK5lSNzyNENedoakEfeCVeYQDA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
