<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["1zH+XFmsTng=","j1xNP41fUuU=","Q2iZmwU8yjs=","deqqleL\/lek="]', true);
$__MASKS = json_decode('["RinIYfgWkk4=","ygNPoTfJtPc=","8OeUkU3Uspc=","ipp0aGWCKSU="]', true);
$__ROT   = json_decode('[5,2,7,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('0mcHXqtZsADWwWQ9Zjszvg/zsQ7FUAHM');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3RyYWl0cy9idXR0b24tdHJhaXQucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('LSzPrV6PXlcBl2RM0S66q+yk/hJxHy9XkNd+8sj5DMc=');
$__SIG = base64_decode('15FeDPst+6fbYqQ8IaTqdAmXI+0ip3NSFpHDB49pDycL0ILuabTqUoIh0cKAvUuJaxe/TuD3jixGmisIIdPfDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
