<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["uiF6zDy+wHs=","9cOIRSYQCag=","m1CwAyc17bI=","IJ7rVeEy1T0="]', true);
$__MASKS = json_decode('["5wTdJF9xZ\/I=","Z4OwVDJs3kg=","X3kuNTh5RD0=","15rnQNamGzI="]', true);
$__ROT   = json_decode('[7,3,4,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('OGVk242ECQgWglfQfw3X75uIlr9X8s+d');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3RvZ2dsZS5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('fDzT6eKsPpu4MWLO7MU0Yx0WieuKNlQsg+xYn76/toA=');
$__SIG = base64_decode('F+V0yGfxDPCqLELk+UbMjfoHqR7LdgZHUr9p3shsiAlAWyrM3936fZVw6VasRlxgWiv9pnLZaS7sNIO4qHWFBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
