<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["0yooDNl5b2I=","C5CDmSQoMhw=","sgRc6dv6tVE=","V+Ba3+cntTc="]', true);
$__MASKS = json_decode('["SXqCgTEAv70=","yjepFg+\/mUk=","Q58SXSqrJy4=","r0K\/g9HVirI="]', true);
$__ROT   = json_decode('[1,5,2,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('p0U5vfI2gIJOOPZ821GsK9iBmiZha0Xv');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3RleHQtZWRpdG9yLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('hmNnSBqSlZ8H/qibF48rMEY5Hi+G9VHcbC1FJuUJvzg=');
$__SIG = base64_decode('L+VLnDPGP6HD3523lZ3lOcA1rluAF/7bV3cWQPVE51Ur/S/2BgTamYRWGMxgjA+sV6B80FjmLAJwqbsaJ+NbAA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
