<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["zlcumf+8\/\/w=","WXPFmvqKOEc=","T1PLoUqByKM=","SyRe4WuWoj0="]', true);
$__MASKS = json_decode('["3slwMcVnX6o=","+GdssMrpVDU=","1XssJJ2pL9k=","a1+RfhYZow4="]', true);
$__ROT   = json_decode('[6,7,7,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('6QvjvieBgwlRI5lin/jCnS2UYSZzcWRK');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3Rlc3RpbW9uaWFsLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('s6SxrpbiHxrccRvRYotjDWpHXpAY5nPz2AlaeUcQcx8=');
$__SIG = base64_decode('nKM2MWKd8zS/Iu6+6YsyvQA0+LFCqRJjLLffG2osI3B9K6wMORm21EuDckJiOEsM5/KRKuOU8jXVeZWpcVV3Bg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
