<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["hqUV8bDtsYA=","oy8gzNKflZ0=","tGzWx9Iaf8s=","mALbKDtp5+M="]', true);
$__MASKS = json_decode('["cPksw2IpY+0=","D+XJ6AKLtMQ=","LgwK244hdUY=","aLz2Cc6qG1c="]', true);
$__ROT   = json_decode('[7,6,2,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('e+uisn4Y7H/d2IW9aHrJJtZW2vcL1rrN');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3RhYnMucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('kGnpA8Q4l6CelVtiJBf+1ew5+UvqukM0S7Z6r0lZ/P4=');
$__SIG = base64_decode('5KX0Hw+vF5W/QWiZHXdySYuUQUHaLpMKgsF0dB5xuco1YMYRADs2mu+3lnpWT+xrxaXRAy6bZwk8GnSO4kD8Dw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
