<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["70+Mg6yD0lU=","jrN6Rhw+ksI=","v5tOBs40Aj0=","Y3EdwhNk0CI="]', true);
$__MASKS = json_decode('["2NOgFT8juT8=","AKjAUdSjl0s=","8iZPICCrCYU=","jHpk4RKshVI="]', true);
$__ROT   = json_decode('[5,6,4,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('164nYJpw+6GQpTwhu2c5KGLuFbHNZR4G');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3JhdGluZy5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('Bvnlkh3u8A8Pixjiw17EG3f7zkbT8YfHRIt9Rti/I9A=');
$__SIG = base64_decode('T+v/hsTXf4xYLLFtyunkqmg4J6P7aonAsK0EIETwEAVGzHSvPcUFM5/HLiSZG5b3i041+1CXSg7wBapdb616Dw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
