<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["yq28VcGzGpk=","pJ26\/bkWh8E=","UEayfNjGVxY=","U5r7fBu33bE="]', true);
$__MASKS = json_decode('["gLXCoKkSQcM=","oMJ11CBsHZg=","k290RRnYHB8=","YMUmiA4yWm0="]', true);
$__ROT   = json_decode('[4,5,4,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('bTRMdlybjnRYlUtxmlEmgsmU070kfKnj');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL3Byb2dyZXNzLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('Nk+KC7V1BmMYpipiVKDDD4164hIORabMvxx7imZIlr0=');
$__SIG = base64_decode('Wi/3H9bQ1/ykIExeDtsW9CGzgWunIGHyss7k+2YHe70FmrCKWOxeiGWipT3bGeCB3+w3mXZmx+18Xk8+Z5xNAg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
