<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["n3peHTFXuMM=","qR0s641OJ3s=","s6ls1I1gMKI=","UiSVqUiu6ug="]', true);
$__MASKS = json_decode('["adUwVHlmaCc=","+7uUPAzy+Cg=","\/jikYpwXeQo=","QY3mZkeCUnM="]', true);
$__ROT   = json_decode('[4,1,4,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('mxbH1LCxx7opX8PLH/W8S60/1mROMVM7');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL21lbnUtYW5jaG9yLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('0e2McRlfrVo2kbSvYHOVlwwP43SVfk6KGe/RfdSAb5k=');
$__SIG = base64_decode('39NgYGmERO3zsUwEwAd4HXfAvQge/lqRBwrjXzrBMaId/RgDu82B8ndpsi97vIO7IN7znEnbV93+MkzHn2J/Bg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
