<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["5nuOZwpbDM0=","jA5sFlnAG4A=","kHf5wkGD80Q=","NM1DWvAb1i8="]', true);
$__MASKS = json_decode('["mD5nzXxbJTU=","ACjF+zuBTSs=","cmLju\/ndQSE=","IuMn\/zmtOdI="]', true);
$__ROT   = json_decode('[4,6,2,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('CfnteqSlR+1sWKnzd+5YMhEE5HrgJibW');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2ltYWdlLWdhbGxlcnkucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('EKyvujjF7SywZUnidx4RU6epr1a8tIeqy7YhDCcgBS4=');
$__SIG = base64_decode('P7SXKy3X8vlgofUB+BD5WUy3OCEMx3ngYj/i1CjvjQuqAkLJXxgF42rhECsc64LGXR+zdzXdZb/hKVh3LgwXAw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
