<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["i4D6Z3WSEAk=","0\/Qpe0tgFRs=","ozc9l5Qko\/k=","Q9EyVpULEm0="]', true);
$__MASKS = json_decode('["GvdOWPIR5mg=","kyVNQ86+U4A=","Nijwh+0g4IE=","zpEagEhgx5M="]', true);
$__ROT   = json_decode('[4,1,2,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('luP6zbj5aqlIy/EoNYL8n1fBU1y/+ZOK');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2ltYWdlLWNhcm91c2VsLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('F8i8kEMPUomOOiDdz8fnp6wCT0PFd9XMkqFNKjb765w=');
$__SIG = base64_decode('L6dmDUmnihR4zgdYhMs+TLfLq4uBLUcAjRLexLZqZgb321Adz9DqBiMvMEzvcxtj9UszGmkPiNG7NDK0zKJhCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
