<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["xXsWWJRoZqc=","byF0fqmZCUY=","1WRw77jZGbQ=","V5boH59BuG4="]', true);
$__MASKS = json_decode('["VQr\/bBgAH\/M=","GtFjN5pQ69c=","yLKhOGDaiKw=","3PO0YI72j7g="]', true);
$__ROT   = json_decode('[2,6,6,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('oUD7cDHmpJJCKIl1qfVssC/Z7rKlKRS0');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2ltYWdlLWJveC5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('pZ/mWDR6C9w8NyP7JYrCO5KnN5VmkgQS3Kf7oiuMWnQ=');
$__SIG = base64_decode('TXor+nMv33q6SEONihizPfJ+o8/dWwyqM5t6mr5oR5c7Vagm0XbLQyFW7vu7ScKICLWaouLIfIdvWH4qDfykDw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
