<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["QLFmdsbU20g=","EP185YSdJA4=","zHeTeW9vYQI=","jK0EMKsaKAc="]', true);
$__MASKS = json_decode('["qGL9X7AlwQA=","lwOfIAQPiGo=","S+Q376a+ESg=","+pJ2CKvYIL4="]', true);
$__ROT   = json_decode('[4,2,4,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('lo/xducWn655fHJ2Ok18ro9f5XUcMj09');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2ljb24ucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('wzkJ5s676SVeTnqfQ5EIoshWkod6UHix9AMZHYnGERg=');
$__SIG = base64_decode('hBFm+7oGYuTI+zZHX1lmEQqj/hdGhR4gvizfvnJklNI2P24NJ1+ejqEbTbbQamkyLI/pM/hl0Pjl0kx7NDG+Aw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
