<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["7BfmNFwIchs=","lD\/40aX+L6I=","fFAul9vgdnQ=","x4AlS62SaJI="]', true);
$__MASKS = json_decode('["+TMRrGqYlU4=","\/JbcIMr5P78=","a1AAv8zwrEo=","d0R\/iATM9YQ="]', true);
$__ROT   = json_decode('[1,2,5,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('5YtZSqPdl89oACNveUAarGpwgh8EGzc7');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2ljb24tbGlzdC5waHAiLCJ0cyI6MTc1NjY5MzcxNCwiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('D68SVLMcfn2VMIStCSbiW8cT8YdhToFMCpwhOPk068M=');
$__SIG = base64_decode('ceqqiCxp98nKAdpP5bTv4WiMPIieFOqwj9kZmklQB0bk2hDg5FnVYKlGDp2kU2mHT/f3AjLo/lSYSF+00eLfAQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
