<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["18Qh+diZSoY=","fyNsLkGFrCI=","CP24osTh8Gc=","r\/kt8bsGyE8="]', true);
$__MASKS = json_decode('["QoeKjOzgQKY=","AFwAvSVotNE=","n5wCSWGVQZw=","5P2GE9ygqDQ="]', true);
$__ROT   = json_decode('[4,1,2,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('aDHVo54D6k1oEreT0keN+aHydh6XJVaM');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2ljb24tYm94LnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('uVb+bRFxooYFbmJScrCnbcaLy2o8B6X9YEb48Bbxzpc=');
$__SIG = base64_decode('dRsh0sXYD5jatVBAk56CauBN3Q4LtoC/SYNEu0/2n+L2KkGNatZuB7XXXFjzNjcHZr9fHkwc15iDNCyPO/uOCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
