<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["wR3Z02ac5cQ=","GctqPKq7ARc=","cfM0q6T\/\/ms=","Rr\/TARzW2QE="]', true);
$__MASKS = json_decode('["F1LeUKYPOhM=","7prMUr0To1k=","D6l\/kJsaFZY=","tAW1INMKvcs="]', true);
$__ROT   = json_decode('[2,2,4,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('exgAmJDOzLVOsGXEYYJIPQYm2iDlA+Os');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2hlYWRpbmcucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('Rid2hcjPGgGiLpIpIKQte8DvaxAGuvxfmM4mo+vcYHKj3IaFg8/x63ruvagg5/8H1GiFpSKPkUdKhXJN3Lrf6sTY7jpScOiyOSoUDpQcJUUWyAwL7azx74IocskoaDxXkP9NolCVBDrmo+uOaU7yiO6NVUZIr/kWmjDD0Ad2LlkwN6aYJwtiavFMbRc1XpgaQczhq4aQP5nEN6rGMPP/TTADJg/ezlpjq1PGhgRzdOTlH+W7cVKeSZKHTaGS1sKnZU43teXHEoJouODAl1hzgDF6xIyu4ob78Yxi92pCp/A0YQJiCRuOjN6OhqOAf95I1U4QVC0Dq2KCqjWyIZaR1eZnFpNx3cxqaRVxxEBXcdw/I19lmWkG6eMZfKT4eRBzxYyKZX8Ocu3WlYXrLHFOMjTE2tGbIwn7zVuhkpriXFofLfi/cKN2AGGzZIOXWUPJ0SfrzBsDOT61oor203QJVezkKcq6zGYSdnlD5ICDcuP6ShuWOqNqI5SHu64pYSq2ZWsDwQY0RWIczfiSOTIMv6+F2xm7kDWfUByQfWSAFDkzJ6PRtDI9u+qsfGCFszD1tTFQ2vp8oHNPBNO8Yu/w6+iAyhi1BH8sm6nBNNnFjJrmrjYjlYyp6Gk5vV9//eI94TkH1eqKveHIo0XmGMRD9m9LBrpluDHTJ6CHW6AZbug3nIEh/UvBFCeCv+ImNpMt3bxtkGAQt1Mn1+ONlENcmhbMtci9FgBmJJZMiAe5yn1bSAvfBZLPZXrnL2REViP9XPG3pva8cNONDwDs41GHTwXJJHoe3eHt7kuzoVA4xCuYBwTyim8nrpX1rxcWOrJtNaUtFe5/wVduGLHYFZOeP+WxNOtcR+smGL7qcdIzOVijBtisPxf2BT5t4+cVAqkM02CPHEqPPZpeVpWX7hzc3v2+DyOgEdiiisBxyhNhllCH4K8G/3sv07I20gyVxwRAy7mvQhoUyl1aWbR4AHagfD/lqmArad27BpBmnsAJf7aLEQPfJKIgUXIvaQdO4RUdltFOVSl6fDESTusqW9u2B+ZR5AfzprkR1dG5rCT0Z5kTvUp1V/4Y4mc/8eJKNHmko1s3DZhNqtkQ39Uh31A+Bqq/k82xcEVc+OhUGSG3ISI03w9ihs30dwZPof4CTLcs1XyBeEUpqFh0G3GQ9LnlJMhiCeF8pPoSlnsO+xX8sVUtcKJ7jG7nB0Ps3HqluTswyP16vccX9ziE3BhZkVjqvvDo2E63PfYsju+k+SvzwdZf8Cs4F2tyPC2Nz7ll3YNrbaB71XRxo5Daar3VV8eUu+Ndq9bsR60jfUMmLIqtCuYe98TfyhfDyI7sCAWh2Zwsz1K4Tr9vrWLEJDG2W8+vX9eQKLFzHZQy26ImEnr3wZbgqsYa0CTjy9W6bmwSwgk33Usn54lsk2gVIpRV92YmZGa4w6ToFuUo91GlMh5h8SAyPTniahWvkX/ct030q44alSmXcpzb/X2wcI1UM+SfLE2tmFuWn99RSI90j3xOi/LXOrzSZCH1xKdWNiwJN/D5YSNCCaXLD0pkA1oIVcQ1H1HBMC7PPoQBq2PDD5UuIbmlSbXAIl+P13LtrdeOGh2SyUIFWT6vgdtBFOTXtOhgvtwBALE9kDtSqi5yg6lMXoVkZfwJrVQjdSRbDNc1ZD31chMNvhJBEtvV5ZlkXzKzrphUUR14ht9dC+jPucmRH0c7egtu3P7QGlqhgPHoozEnTzCAWY01MNawxfs6fmNgrtGtN6+Y/wNlfv+fcTV5Kxw9itFjMazinprkQ8lWulLspFf05NXvBkzVvj2tzcBAb4YG6zjN4dfwWeFsF1PiFPMlEtaTWgYoNi9a6tbXsrpwLj3de3yaVMsrC/+ntDDyc4am8NKQ+G/bhqyn1WDvE9Zx409YH8/t2gNp4D9nAdPBIF8zMzkzSa/8W2w9d23ibcyLNbWAsD3IlVRBqr1AGIcxurI0EAUlqpKBxpeEUCvHUwJNdhOwWpIohu0Efd4dbH0yGHSzPv1qu/dKnWhZkNSMZcC2fsLwR8bcS9LI79oM7NfuMpQmhb3MfHwfoy9UE4SlhtPqIooblCsp6iucmumZ2T8saMtWHmUwXEmYtyKPdoC9vyJsk//fadwbk2g07MmlEBJBfA2XJ4pO6notME09HkVOJIH34V2ftLn29F4CIsCIWYpfHooNFRbd9RX6tkR+OLKBQvntcZoM3CCDXB06hII65un6JJi3BlPm7v6gOgcs4gcrWxjpbQbzBB8mvIrgr8VzfLbKEEU8JHTrAG1jd02y0dq+pJ3jUBpXDrGikptnUf7zHLeXEUnutY2CrLkFmo2EbSvj4x2E9EUXbF8tDI2I0r4vbv0UtCLYi3oHeJG9xYUjrVGx6nT0luhOpk29rAq6aYQtHc93VevdZzzVl0pEZAfVafgJ61R+66CZ2epaqMB2CYCR6Q3PI2emlEzU/HVmt3ZAhXn4orpwnPPRRRdrtRQGdG9Sm9qJcG5+moSa9vvGjOgf91DMG4qNsdOFh4NdIpcoGwXRR7F82+vaqHuyqS2P/Nk5vnqyQttETvsiSwkGWUTpLwY3TqftXCLlWtOonTQYa508CR6E4kOfTtjmX47M4KGrwN3W78xeDt5wOEJMUuPFriB6r+u6JTDVSOweXmdsCdeH5LqZFKOCfAWTiu8aJ6VGebIQvEYbIKPB7BUlXm62dVdNBJtsA/Xudtjl7QKvlVtUMdHKHFMClyA+QNqoX8Uqhcf1Y0qo0wDvFHBJHkMBkO3pFcwaibdvH6cukszEcfqSL7H8PDihEyynX3eUr9XMyf2YpnAAFxIAMP//3zdq5fDoU+iZnBobBfkDZxBS1zWSJJc61XawVst3iOC3pgrNvNC9c2UCvOxvUsUIyMMt7FdHlteRRbqS3xWRK09XcecTArxwOeFd2Wc1JoSReXtC+XYrBudTSAc6g0FvbkRX5I/EiYk8C74NqW61brYI4p6BdJGQA+lNuGh0wPEQRHfQx2DzoyZjove4HQkbG9PCRn1wbWe9kaqQvA5WLSIlrxkZBZeaI2Ofw9uHHlOCTQcUKMrnaX6G0gs7dmVZ890ipYJbKgQXRQ2juRXC8h/Ruldwtdj37Wve2zetE4vtk5EK//P9CY93aWCY0zEjyblOeIsp8+hnodH6atFDpyODJ80txO+1yA8bmzivyqG2vC2wil9oVus/WSI1+G6YW5Y0YokAhr1VhfF6gM1OEIpRFl68hoKgWKmzonm6bL1Ef/u9rI3AGLX6LRRuaU9tmVXqQERByuonm7gJ7RwvZQDezY/1N30iS4gaoEJ+56LpJfgujEQ2kRAOfJZq9OIsjMu4LugID+MV38oZWfrnjVXUgDWcvV45XUq4oFh5fSrerCr3aVnfLS/JNsoCBkSjD4m0oCFaEwwORHerNvCFKaZkEPwaVzcfowD/lBnTeJvhfz3Qw28h01tGrreKqohGlenR86IwfcZTVyVdmmmLlzQ5XVP4CzVk5nehaP0L+rgSmr4g4QSq6KHxfRewOrCNjZ1xGIeWDDrlxUFdbCPA9EjJwi87U6noR2+uRWtLL21wVBnT/qtwdu+r1fYe42hCpph9lNyu4LP/Q3IXxZi1mfGXiXHpkxTehcv07BV6V/znk/aa+K/mrMy/PFMA/2vFHuiy/yLVM9eI6aMTf//j8vi+hf4iKzus2M88DGBKgHboGy8CP94h8a4caUTchNqzedbf11/RxF/ylrTYqZtNVtU6AgnyUAuqj3N97gy+zLuzg1Z1xmLhso7Wk4mcUmjdhs73o0NAHeNXNnQCc+pW/f0+MfcQfKRWL+TJj16oLe7V0uBqhV/bcsKp7Vm0QMpiQEgIkM/Seq7gsbgvcsUmll5ZOs4dNQnAoNt1vV2XtNyRwiQndOVEZVK1UkF0yso/yRdwm7nJ9yZiKhgzdWNBK/zAsbZX4xVCADt0h9J1kPug0ozL8jRYt/ErBJbhpX8SjwM5qZhAUOXLu5e8c5BzdMZqz5HKBWYOQzjP17tv9JdpAsnW1utxS03qpO7bHTctRsxWfHM4XSGXNvUeQTrxhEAXmu89OrlGurs1+kNxx4EUgRt1c1ckhxE4NLrwst1zZ2zg0MTAmynBg/rV1BmisX9VWWMYZsLbHC9otqA6rq3eLpncLUUT+siYDJwXOpiZRD7l/modAAqNeiQJxlev9HutqmOE7dKnSSV0b1YB3Q/ZMz+c/nvuyzFNzsAdg6iadisCEmdAehFKSI4VQ2hAWJfc+1NQzcCTPpuo2qhXb9SX01/AGGrLSKrRMyo7dEAIujDvmIFs5YPaVNoLUYhr9tpj+QbY2Xe6Gmg3ZjMgWgtip4xuYgmjVnZgXdwvdEgJ2OpmFM4WvF86ZB+4ELQY5RSb9OODH0mSj5fPTWnUxtgS6wXk8LPMVf8KsIHjf+7svMmmBZqf5lENrY1TddGI1b2gPO7LIbwmXKbM0Ko1Bgu1LoPCsWXoB8wz0yx2qPi9o+NCfvri09UF/vO7i11qA4DPXleoGBPh1lnUGqnYVoJ9ggLpGKrPJM1PdP5InYScg5DpYRIgYVutc18D56qroxYhlSFkNEimdRDcBL+oVpWcZeNAZlSeEHHHgPAvDNDMMawd5y9F0Uh2wnvVHBfkwiyRkUrgcH+rxQcydHkcICQZShOnqe2kbIhHEqnnl5hkyG3vHpA04V7dbUBcPrAxXFGgpD7CZm7WW1CLIj7wgNORKycjiqL98x98gKXhrIs9/PpfRwMvfq4WCPRvLCZ/jual+cvy/m6wP1a7u+66P2l2grqNeD6QQ61nqyxE3BdI1QrHnozYMxfK/Bg2fMvqJeXxTTfNGAbQHHftfYFHp6KzHFp9D3PcajH/YMhatp7roEMK660F5n9cGExXBYvNXblnsAdGEGYIUaMID3/WAJjURV5YHcI6ddh3BteAxV218yKfhbLjxM8RfcJ2RkhVc59eIvn3mkGeaGmPIN/f113hI6w0r60a8xBn0FoAUitt2YYERmOBG+bbgPTaGvKmOdePJ4XzW6myrtDDENMzpAI3Q3f/fxjYkpt92hM1VR81D5qYw8ysUj9TV1jhfoQ5prEQTxrTAA2In1dAzA42e2Y5CFWBnV7dj4Lrz9wegb2KxMZUmC8gHegbi3nRuK2efZckE6NcNkmJO3Fhq9Rg62pojcqaSfWkMqAJZNTcBe+VyoCOjFhilXMxs+3rkiSpHyXO73JYnGRBGm83yclanflh5tbh1Q6jFRh3fm1ja2m4YbrchTPmDfb+OPc1GhL1KrYjt4+tQOR+Bq2NM0J87IHz9XP8ibStYtrPbwXkpe6qtBcHzC+eUmhbQN/bwQT363aPIrCXvnJgPWaUZCxlz5ZDmtHPEhQgi0d+HjIgoYhKVOoYtD3wsAcmfDPGUIYp+Kg9sVFbliQSDRv4YpIsxuJH8QCCVfXdy9fZ9JwFSSA64Ka6DQtQaT6SiC4CG+sX9oM94WpetuYHciS60W3UvX/V+xfUzaVbz4Vvhk6xPd4ENkXddP+gKSC7Gl8JwUOXNjzwYnaGYCJ6WE93owdx8QzBcP9grFxLmCJuX7J8bsrzHy0bqJEagKqpMuORGJfRj27dxbZ8vgO5UHc5AuqlUW8H2tDj+ifMHMdBDBKhlIy83z5dXwmLvd0APA8SsSMbiZI9Bv4Xmp9zuJnMtKiWmm41bMFPEFNG5Qv9QXQDLvpYPxioFlrGzQ47CxYJEJqNSncmfiEGQVoANpt4UwH5JSYszhwDRcelNaHZdW9QM77Q2H1SmjecQX9k+d0LjWJpRFV7vB/S9cLUMXLM3oEngLijVqa+ioOwjZF+PwJMwiz38/0zVXLFyS+eN9rzypkWvfTvOu+aBDr8bZ2dTs6SCtm5ugedHXOojEkffGHqlMratdNCMPKJkzrUEz8bB68Fyb3Wj0DvBOeD4JFWas5aq+SuBVR5cbEmG+RtyrrgqltydVv2Qc7nRP6Xmd/cUJtvjIsLTMSfI54eTCqOPKvES3o4yDzNWRAzdqOceiWbK6kQAUcuLfl2SQ0a5cC2jqqJ1MeQFZEjhceQlsb0xF1WxOJuSw0I6wmO78DaKMGCFQVeOOwWUWcw24Nwc/9Tf7X3yqBgTkFeU89BJuXL8/D1eO9TCL4PagwXBxpw3vKIsQJsSMvaMas6zDaMkwVZw9JgNHHLwAp4kEhX3wN5552lcPu2q3uoYAbSHODcGYpZKVZ3Obt6SEkL2W0xeARHN9WGtUyo7PcbwBv16/hvynoAjnTiMUUGpgMRL5BKtFSNO/v51MA7HhZGjWZbPSOE8JrrQK/y3DnUodNwgkDktv3Tx90LFhb70Cpqcfo0nr5U9BQidIRk/HGrR9RsfQFFZ0ycTW9RW/tLlPfq1dxVwctMXO/2jlVMEp5n+tUtCYvnfKItozHqYNuaR3RDnT9PY6syyW/YriSOL1InLg8GzWJZanT+uIjtrE5+qUbIJp+dIJeQeZDGrEh8gxPXPzTw2eeSJEWeNDnPkbUIX02RXRSAuKZ01TBJZQDYHUqXAVjX6R3re3zUhYvXOruiDY/95i4MIbl0suYrNXJtg3XKjozfduz1fuPlInRNWIP/cQ1RmiF9saBQawaneqcDGfAdPjNMDV3crb4EjP4oI55Teq1iUzCIZzMY1KOgrHnNyM6QVRvbeIh0iLsNH8L+h9ahP0AFds5AFeSEWxRPFFdwDfahATy/ACQhwIr30p1KkAOBK5sZdU0vA+cpCMiaE1+nlRm/mUcvqPuw7Er75dUBoD/JDiykJqE8H20lLqSAzJR/rZ+R7dnxFKslsWK8rm/iCx/HSRwyHAm2QGce0wzra2H4c/L4GJiMs4kECnJpoNW3zhcXMi0bCmc2dC+v1UZ6gomDgYGCxBNo9x5mg+ap5d6PVct6fACUAKgA4X14cFB3zyajh3bQ0CaRmBsVoQocDf51dUz69WGic95/0mijvc+zrlHzOb5L7l5AtQJUrkyQ0bPfdtkWTI5dpRdFtNlOj/7sM9+RpdUETVl2bkori7dneosSWHbS/t2Dl79IdZtVsVEurT/z74z37zaix7JwuBRcklZqlzQQMXYwnBmoFY8tSUcx0fGqxbphHpNJLizdxh3H8CSbbxXHUk/XZJBLfqPJF4e6aDcvirW/f/gs2uIG2iaGL7/g3jFOelx3nAjk2a9Qdiq6scCZa2RBxupDBZfxurbiHfJu4O4igWjcpJWgIYjWylmD94N60uGNAoLG2kfAS3elX6fc3gtMVB+Px3Iwk6gQX0m29T60lHdTND4DUwSPD37rFFoy+zMxD/3vbLHeKzpRHQ/D/PVPCAAWASLCWpmEdMFf1V/pMbxIeji8NuL/+u2Ers6EEdS4bvSrLeQqOYCexs4q8V4e8uHGqBoRTgZj3P2ZIXqcoL2RURh/qNjlp6sVZ/1L2MRCIJV3HaGLM561Z3V04HMTyhVOZXDrFngbFB/iqbMuvvlUOMauXkKMveQmKXOn4tIwXWsggIEf/2EuOg8yS85SmwwrtoD+j6JR+DK4cZJ1y+PMzZzggww9YBQgC6fid5g7i7bnNLvRqP5Q8IRcIiPRdYVyNpuRF8HKM363KEBPyOdk09io7/+Qci4THHsgAj+qqmGchyV87nTdiT98TVpRmp20Kac7Ecw9G6oS1OqUvFDgZbDnHsQ1OFhkeLzHzhoYJR4kE423K7lpd4qu6D07VRRM0cy80nMjoP3wDckt6EUsmBARzPsMs8ewsTasuLSYwZNNqfcLzYXOxOJQw1NNawaxe3gKxRkru0CDmCLky2Md7MWted2aXIhXjt9ivYlKwRyucR8YDXrFtz5vxVXbABYlleF8vYzwc/9bfRofbVjacJNE5p1K8Xu5m2r2kADDuGlRfgknsv80Ffl5hJbymzrNtkg7cz4mEmhhQaCHmOK2TdbMCdea9VDG6KZ0TE57RzTmzldUeedU4Wqr7uUPtnm62lZtiEshbin14KKjI2beZoY8TWfNHJ0QdLNrCTjC+tIY3kvxCmO/6oKWHP5QegOBNkvP7DBSYOwfoW6oghAunBOAUW+bgpbbgKWxnGhw079uTLiZMlHzuOiPRqhCG6u2NpCtt55DCiefnhUpAL2IZZYfhXuA0u5tfPatIXQw9gC+BAYWXZh3aFNCSsL/ok2ztUIAHbjnVaYek60IhqH01/n+nNiXewi8u+VdNRq6tmEJ2JRC3pPr1CmyHyZW5umBJGdnUsWd/GINdPRbVRlx4BbG7SFv2t900NkxyJ2MMv+Lr4ze/gr2+9+9eYvFgeoMYvSowe6TZns+SiCUsuqdNqGxqOu3zmAZL0EAzKUChhKUnLt0JtJZNlWoJAuBz5y1mDi/RZcMhAA2xTE1LiHO2ADZ1hKOOFYD4RmcitmG6+jGdQnGULaZ2o4CKvcQHv6WQrMr3FaqgNDRu2MfEfROZm3E2SCf6jbS4pO8SXsLJfVIE309dRhx1synJzMdndaHuAhG1r9yOQ/fkf5McJW2ut8nJe9h82yvF47yvpG+uNjiclNLcWN3g8XCZVpppJScUGksu4jGdGxQWzNmBFcbG3b6lIVeh4zKYb7FI9ycbgLD5PzZpp0b6hQ0hkfhNCDOkWcCacmaNh4NdLmz/i5Sp6C5Bfp5js0sjmH9siCzdD8dGqfrJx0IaQhJsXLdREPDJPckOh9NTyI3B2kvO+bnNWQdSq7nUd4EhuYYM7+1O9ooUm2lROVQRSBMifZKfHmfYH9oAQOUvlPyXue+5jGoWxsuDMFtjjhObzKRPevMcy+VnrxTxXJD8HYcEmpfWFI3EPtQKFR3BUwrFq3iO+Mg905TN9iqBocKfAvSsmSO6pWBbAqTmRf2QITVnOmMavP1JS8tUJl2C7ZVHj53FITH1ZFIbsrEgx3uVAGoV3+buuxx+j+1iNzB30vDFw5xEaxIt1zysfXyF6ks3KhhAvanpSVTq5AKUumjXqdrj3q7AA2KLfiHOGS/gikA0SpSA4ozgyI1cY4C9Rzh4LWD9pyCODHaw9tv2tWXBvK8YATJx6oOndptBObkYnY6b6xa8Y8Is1FWtv/AQ0ACuu+7T1W+YfmJnlykLpeZkqH/KBnjw9/N/7jkh80wnhk96sPA0FBiaqovWvR+NJVsX6FA49xmhFPVdAaqYIyEtr9EQCwLPjkZzJJ4dTs5mgu2tNZn/HD3DZHl/2N8bQWoIhV/V7T8pMYBGIUWVAXjBW+7Z6s4n3OR+nbhhxDNzSxgchoaRxxhSp5Hk0kdJVsWq7q+NqnBUJYDMlKxkfIg0ZjSgOmnrEpLlSvHD3i8z/sYavov6n+ohP+pTV2MaOS18CJu71JbdTVbTPcYgYLq7hEADfKa1gIEa8wZIDXG7dWm0HZPhU5Xt6kOUwJeg4bCW2i4sn2rhkSZNSR1z1YJrzJXkfuckt5QiCSuCMAnl6lBR4nfNjcdy2B2Rnq9mgFHG301H3fKlNf3TdZEhJYYO0LXLNLMWomJZPhxOR76ypcgYhDFq39tIMn8fNZ0Jqbp1fIs3XVaGL9rQMLK7rRfkLclWAARAZhc5QjKx69nxThbwX/awuLGg6stELaWZAsw4st+u7M9zQBzL1hFflTRTvtQ+7lLWI9BYTe/p1KEa1FEh1qn5tlTLFWVwuMgBDYTd1kbcTt592+WgAZl9rvsrvhyK3RrwNtcI/QHmuuJqPkstjfuNGzyxJuBlwytXh+GZ5jD1YCsMWtrPvbOp0/JbgYvYfCh8k7xZoqcRqO2pevECCnoUKhcu5GJVbyn4xBtpsB84QUdCvVd9Z5XhCJtRrsH1jbsxsYRts/Hl3rni1GTH13JAx4DBw8cOnO1r6CLIrNaZbLKt/znwsftfoaM1A1B9D99QAhzElWpuGEIAsFZcSyJh/IOMhe8eTIhIoBrj5dTX1YzjuJTqX9QG89+FXAQVRA9v3E6F1NQpYK5WTRZc1ssZ7u+go4ecrbXDRs3DZGUA7Pf/sDYn4DXPXZsVciXXe+Mo2eB2oksqiNRPvYKl6O8fIOUlD9+UKEOD1caDTHmLb35H4LBaGjxX9E4sPjPUF5uLYE3UWXNvWfOOGisgqvL7fUsSQVe5EXVyoPA9hxYI2n1aOBiMxMTfNmyNZSnY03vYGQ80ko+9Jsg+zDvs+ZPgG5yLyWZBT9SHAHX70BfhmOhv5280uk+LjGKZcxblp+ntG7+0pBdHSrPPFbhZeTZrimDeZAicebEM9IPhXcGXmG2IkDOs13EYtsy4aeOfPe1eJtrS9dZ2s4VLDGip/GhSj6sjZ/niljC+xTePtrIMgQsTFH1T9Z0sgkmV0/NT8cDdNxussLFLQ7Sh3EVx76o8diuvgrJ2SIjvdJy+3eoj0QOFdBrEh9wqgEK1jsNGcHgrvAyKe0d1x7OSELlNpHhPtE3k060y0Fg3bcAgwWnh/HgB1Rz7sJ9no1cBRfaQTXURAup5NX4erH8AIrnuzqnwKX6/MRt/oDTfW8u5uryttSF3YxmYFhcHm0D16AcZhSXV1a3XSH5KmCQBXq9cQ3P8PQFqiMuYfpI3MJNAqFyOxzbWgvRbcwxHfjKF/MZSaLzxf9lSkBS3Tqv1zCy6E8nLomK0GcC1V74tyWHoxviqt2LzuRbvO9dlyrp0tthOEW9JXsoZljwHyXEjGiB6qRJiOmupx08vjV/VicfB3axHtMxb7T2i9LHhuCTeCdW50TMmoBbobtEzovNa1smKFs3+VmkwOCVs76ZGHkWc1zDy40fhnWeXNSA/57vaTCoV++G2tQCNi+xCbhdeGotk9ZjGRqqzzUfIRLzviV1QlGcAq5qpmBRuODUMGYqbbdeyL3KHi/Wzc7SqpbM/uKWnK2UdUB+uc09SwzQxdw/gb5SThEzyVhpp+8CBsuFcN+UEEs61V0zzQBiD9TeI6nrfw4a+35vvKP/833tadkeFpk5tl94wYBuF9eXiSuJp8ib9W/Yb7DfPwHguqF2OlZUvXpCLT1+VHZyHLUolQg9DN7A0vfEaUHLNEW+qe74QpsxNIxNJmtnpXpUNdqZqrIUP9So9isSh5Ln4abFtUVTXvCjW4fjllFmv1xYzaCflwiJ3SROep9nDLC/LSrN1qofXQRnZYbgkG74MrUelxk1X/M1qpAi7G2ZZbdmjoL+sB0LimgAtZAbLCmRwxwFCexWL3DXQQpmAapPAMy67BRzHzL5TnOffPzlGg6mnPzCkgXITFftiLQwtfXKddFrozMMJGyW9z+4WrX0aMwyAev+5Nuvrb54/8db0LHMJiNddosBdlJgwe2OSLqc7PkIp/O1pYidIci1DUiFvXMV+VSjuEYGq5QcUJALVgFwTOTRnzrhZOfDEVihcvS77j/Jaa55QBnpRwx3NRNOrcW9Vnme/x3Z3XvQMji5v7KC/XKG6JYg7qmJL23D8klk8d967qkV2KW2Xc7D1wGnUEfeJ3aiWE2dwUoR1bLC9xXMB41eOadDHnmRsfDn+pYpOu1rAjAeOCzRIFh8kJCDdf+oOMXFfEBI65F1nhxfoSf4Ux1DVPanAD2YWXJNtR/p/efOGlFXsxGZ1JmTqhZJFRuyH8jjZozpbX7qI5ELRG0ucw4fy+eG3NgtDlbLi+9g/ysG2GygpU1uRLzbn2tBOx489y3KoNEAZ6QzeAuBmNMyDohAtZg0XPObd9ufqsrRnMn+ZsI30dl2gMEs9EGeAtikeL8fNwf4Ibfwf/LYYb7DG2hfHJ6TsL8BCU1Ctx2oEQvSX786GgPtad1qn4wTRySwSwOXuP5dMm+juPNugP3rirEO9nS5ZedUCL3XrgRmccm7zmxdAyG6AL5HHUmEuqt25kz2E6Im998/hJ3IYpfXMHQyanrwKRoZ+BbCGPMr2cuwINvcixnoUu0bHZfo0zNkkO+XmAh53Gjfe7xOTGj4LlKFuR5tg1IBim6hO6XZ3Xmvf7q3HpGz3AUQv2s/EGAAgu/E/dbpPgATCWawemhYYsv0ePM5smjr8eCaAPmHglJPRkTiypJ9poD5mMnhJaoiYZy6rmavMLz7GHtBAOLPI9AzHGey5TN5Q/4zWoyo3RLZgZRdDphYDUwpv8dsrhdSHdODWMLoczXo1DZL8H/v5CeedrMiI2+9NHp9cNdXwBsKbMMK7W1RAFYoeT+XMdbk6yR9ub0LKJGvuJ+URphtAFvFuuvvQaOfTuSt+g5U2edvXl4Lx3EewDcgHNFtTfEOCN3Pg3+OhZmXwoVW6KvuFbpTL81PBJYV6I288yS7LOMzxl5ows8uC0ang65IAADfVMGLuwqYvfcViTjLeCwdbv6VaJf1f9hnNpEdrcKSgopv/wR5+tB8CMVz6QwBRE6Z/XGFPHJCIrYhAgEtaGFTYkQnIYAIlTJ5d9zF+VZMOF9PPiivKbkJs8uvGTMF02XkuKy8yUJFzK/MF064SbQTrQyP1KC8flU4Ktu7O1cHIX7+QY6iex0IC+pJpo9VjpgJy2XrO2einfD4TJlPJuxxyj7hifVCM6X/49q1MT+L5GYISIm9uA/HZw7pA8JC52KfPf/rDsapJY8cDj2FAtCk6e46cLfqDMQTVpwONQIsHUCBEW86p/V3u9k9B49M5/gFvPBXM672X78D2MdHKioPw5Z100z5/l7mb3J+jGBVA5fufJm+nxa58DCQDP9qYFo/4o/CCTQrATO+D3lA389UTc57suHlxjqQnY6C37nubzOnep70hSCesuFlmCYcZ8uyPYsM1b3IY5BIBZQWRQ0f4DZRYXOfwy8Lho1gfPjBJ4C6CTWPLYgcaZGfakvCKZsPz91K+QtwhVcu+iRX48q3mgccQgaZoKhM6W1PtWuoEE1un9ADGAv/7x5qx+L1kmNSKjy7mKkGYLGqmfIBysDWBeqrv65lg6QfJGtZD5WmQ++suUUj71rt56A5RxwdwgPMRhldRlTHVHF7QkjNhLHKCS/Y3n5cgltrr9SdEYNu1s53aoI09mtmpmkjG5qmBxTxse82seY2qa7w9mMLK6ryQuYuPraSDXNzn7j/obIhEG0YRSeoniXlplTylDmkaNvTsynj47BzLCoSztgvMyo1Y5NuHtS1KGyKF0q8JMTxaIvFMELOp4NXN7raUWCOlb3z5FrqM7PwPoIZDn0IZe0CrTqBkrdL47lKDmLAF1kBqqWbUtc63iYW/zB5rfUkzZnY128cLVuC1XEuVOOIHNqVEY4XzHH6k6qgJJPExp+ZL+ejQaWoLWztYiPRKbxw9WDniehd3lBxwMqpJ1SggiXleCsRdaGgbSrm17MwYpMnuvK9d3+JT2Y3A6PDkdRo01hL5u8MB6UcVngRGo/+qxR3hX3spHaC/TzXMQVyhgv99OsBgTUIQdnYlH3TDiQXbyiVZxLweffu/UIFWnBMCPSTkXcTujftlGn4e7zATlEpXhd4JlMXOuI38AIc148CfsoVw5chDCHTIfXFspT/yXqyzGpMgGQNBDPYIj6Q4kDUdHh0L5/nAOoayAlHMoi1UipgH9PpCBORP2IeYPsEYM/DIpBpptbR1XjD/eLg4jIQvfvG4fenWwtmg00o2ihoE93vS2GCRFqrc6YLeBhb8UA5cEOuThIPKFqsXiQrmhxjRUxm9jJkfCYLTVdsqFZdDlyPa+jDge2riD1JbhhCNrbvSdbOLhK/w//EloQhib3ENin5EHvTDni49dEI4epWyei0dEC8v9eM2DCN+F7636xGqO1a3r4J0RWpv+yDslIgPqUCtlL2gZarHpg1SKRQfL3SfEteUESbFNhJg+luRxy5eN/hdY4wgpl1UTTy6VYm9yWBRXuzsoOSZ5NZ5txoYYFel1brOmuarP6RrMtheX3/BvqAfD3HI9F8c1uyYiv0rsLg66pHaLsQDcdeA+lrwCVIlfYVwUjeeyldNspmu5285tJDPvG4ifq2/a5wHT9wd64yEsWQLWocDlwM5VP0y8h+38ZfkWq81wyxeDas8Ga48TPrAVRj3dpD4+1QI0kEa5IZs8ACbJFd7snbtY/1NxnKvohRUA42VUBQ4zjgAjqtgDQE/uRxplrt4q4qc40YEQ85f8GTOc06DhS5av3JrU0c9h9DtYihe7n6iX5Dh9YPdVamQsStCKioZ7xkvGDvgefqMph2gxCIVZWUhPcYYuYcUWgOfEL4GY/0dvvNNm7MOug3tIDzt+PWreNw77EjkhDzkyRF7TJq5j1Jo3apAUi2yQT1y4oSdWL/9NcKiXe7W0SHXZQoccGooMFX6ZZCbcPu0loYBiefGILxJ658WdLzEeCm4NNXDAGfHRRNo2hIyz2UZPyfA5OlkHVpCKdEFJGmueKQASxFrS9EUzzhRydFQR4g/wBtuFstXtSY8/ZXv9tjM8g4oMtUYwpft7TgBRu5cJ86iptI9Iuy3qVy/hIrkCAYuI1Zpj7X2KBZpoS2B+KMNWYZMn9NULR+058PE2nn4jhA0U6XJuNFDbE/jUyGTQoZ/HWBVxxddtvIjJha7ehL+P9baIoiip8JgJ27J+BWziygS394IwM8xi64+q5oL5t0ycw39gUi6q0mlu5Qq3dHojdNzllIMVriikq038BIP5J1F3Qm6aPSycMYiwnl7wcuSXkBmB3giG2wrjYQZ3qlY5dasQGjTEVWxeT3tgcc2UczWgmYGo5atgYegf8u4sd+j6drPMpCyIL8C9Q9o0wqAftjL9y+tHdj8G5jg50ZpQGFuNCGAkPvtmSJVDUsEai1854z9JFUjGJ45xvBfrD2Ldcw9tyRShZiRcp1KD8uGT6u9IPg7OQMTIa4rKsFyFYKRVUzJi503VAtQr+S4+vh0tH1Irxb3950MBWHmAONjikkqWQ7i71UKvGRvihfyDzo5o2ShDN8evSf1gSdAeRLlL5yqX78z1Q8930hF47zI4dQZUvxeWrrjJEvYcVLQBt8YjLiwhZF309b3z6g/rCQ4rQhMdHf8nWCn+SzM4kreKfT7vsB1Jw5rf74e5+B9kaRYVner86bfh+6JNoFIZY/QH/ePXFQZukszktdQjmoVi8dt8/RXuFlSMnatva/vY5R5Bv2CHI6nhP3MKRtS0FFbAQ4+WSFcz0CU1CKni6pDxkwumEyaFgJqvPPtZj7WEyFnooob2mLX0uE5mMIGAmhfEbb8Q2oDRha+ZKC1pGTNiCEkW+HksFiDek5iPW5mkwt2fkpvMraKU8ssvLyXu4un5PBWOoYW5HyBYWH0xXCc58bO8ckG3J8sGjGbLADOtJANOCwU3N0JSmYgrh/cTBRqUOT0maeIc/aTRR+Li7+Rp3Uc+T4Zg4UlLrk96u0UrufkhH48bvLN5KfYS9Bm+vYiNrEQec2VI2FpOUGRc5px6A+OdpWcs0HSWJuo6u3TyrL1kTcqgSW0h2SVcd4X3+SY3BP5fYFlM6fIZ/yX7TiNBC8rQKd33ALQD8=');

// Signature verification
$__PK  = base64_decode('4LLOZU2af7YaAPOiF90iKKkaBggNtflfIOLP2RuIAwc=');
$__SIG = base64_decode('LN0c4N+Hwcc7WhX5g8e1YgXDYDzVFNb7R3etInuS89cGTrlUPgedXzT5zDlYFxRlRDxBoK4O56SJTcpAKRMIDQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
