<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["FjVKsvjtGns=","XiWl3Rf2bd4=","pquRHlZbRoM=","GY1vmzKqscM="]', true);
$__MASKS = json_decode('["1mqSOhBG7W0=","yJJTndwYCaQ=","omId3LgRu2E=","EZNe8pP\/7dM="]', true);
$__ROT   = json_decode('[3,2,4,4]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('AWKjvfjpApnnE64aCLn5VAQzs2dDh/zY');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2dvb2dsZS1tYXBzLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('uHxQUHf2ZyZqXj9mJvCsp4sCqsNpVc+OqUlWwuWdQsM=');
$__SIG = base64_decode('bLJBP6f8EsbgXfEMHEpmVnVCBYZXNbYlCPOeR49DuNREQNzCrwwGAx4eZUqJsjQffn/SgoxqID/4l1w3FtrJCw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
