<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["5lMm8u67rZc=","bkxXtvIMWoE=","oroLWA7yZQY=","SOq62KD\/bRA="]', true);
$__MASKS = json_decode('["X6Lr7d+lqUE=","F9T8w0Dsy5I=","+6j3nGwCVbk=","+F6oKaKDOi8="]', true);
$__ROT   = json_decode('[4,1,3,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('0/X51quT++eO8Mdz4sVxspMNGfotD67H');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2RpdmlkZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('kGCs8AjLXD00OsuwNX2rhsSsaH1338SnYAv+utQNGeQ=');
$__SIG = base64_decode('EmJ3D7F2YnHAiEglklUbICms86LNAa1BclUO8T15PFzPTyTmdjLGk8HQCohHRB/wSkWkE85yI6sVza4iMC14DA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
