<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["lXWeMOdp2wQ=","FX\/8jlO\/Ka4=","Cc0CGjobhtY=","rUv3LQzWK2g="]', true);
$__MASKS = json_decode('["saW0\/d0Is2M=","SWPsHqnESWI=","qntc8xklqNw=","pMDhOPH5vdw="]', true);
$__ROT   = json_decode('[4,4,5,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('xrPaC6dXRoKQEA7po3WJJ2NOeK6rt34q');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9pbmNsdWRlcy93aWRnZXRzL2NvdW50ZXIucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('o5eXBJic3jVPjVmEcmfHF2D9rkZ4jDsFQRmgBkyYXJ0=');
$__SIG = base64_decode('zrsij3xFVQeXgELS5VyDWxgEva+49QH+3nGyXPHtiL0Iyz79Y+AA+FWiQh4wBeWjlfhQERd6FdVgyZE0retTBg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
